% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_TermEnrichmentPlot.R
\name{do_TermEnrichmentPlot}
\alias{do_TermEnrichmentPlot}
\title{Display the enriched terms for a given list of genes.}
\usage{
do_TermEnrichmentPlot(
  enriched_terms,
  nchar_wrap = 20,
  nterms = 10,
  font.size = 14,
  font.type = "sans",
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  legend.position = "bottom",
  legend.type = "colorbar",
  colors.use = NULL,
  text_labels_size = 4,
  legend.length = 30,
  legend.width = 1,
  legend.framewidth = 1.5,
  legend.tickwidth = 1.5,
  legend.framecolor = "grey50",
  legend.tickcolor = "white"
)
}
\arguments{
\item{enriched_terms}{\strong{\code{\link[base]{list}}} | List containing the output(s) of running Enrichr.}

\item{nchar_wrap}{\strong{\code{\link[base]{numeric}}} | Number of characters to use as a limit to wrap the term names. The higher this value, the longer the lines would be for each term in the plots. Defaults to 60.}

\item{nterms}{\strong{\code{\link[base]{numeric}}} | Number of terms to report for each database. Terms are arranged by adjusted p-value and selected from lowest to highest. Defaults to 5.
\itemize{
\item \emph{\code{Enrichr}}.
\item \emph{\code{FlyEnrichr}}.
\item \emph{\code{WormEnrichr}}.
\item \emph{\code{YeastEnrichr}}.
\item \emph{\code{FishEnrichr}}.
}}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.type}{\strong{\code{\link[base]{character}}} | Type of legend to display. One of:
\itemize{
\item \emph{\code{normal}}: Default legend displayed by \pkg{ggplot2}.
\item \emph{\code{colorbar}}: Redefined colorbar legend, using \link[ggplot2]{guide_colorbar}.
\item \emph{\code{colorsteps}}: Redefined legend with colors going by range, in steps, using \link[ggplot2]{guide_colorsteps}.
}}

\item{colors.use}{\strong{\code{\link[base]{character}}} | Character vector of 2 colors (low and high ends of the color scale) to generate the gradient.}

\item{text_labels_size}{\strong{\code{\link[base]{numeric}}} | Controls how big or small labels are in the plot.}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framewidth, legend.tickwidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines of the box in the legend.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}

\item{legend.tickcolor}{\strong{\code{\link[base]{character}}} | Color of the ticks of the box in the legend.}
}
\value{
A ggplot2 object with enriched terms.
}
\description{
Display the enriched terms for a given list of genes.
}
\examples{
\donttest{
  # Define your enriched terms.
  enriched_terms <- readRDS(system.file("extdata/enriched_terms_example.rds", package = "SCpubr"))
  enriched_terms$GO_Cellular_Component_2021 <- NULL
  enriched_terms$Azimuth_Cell_Types_2021 <- NULL

  # Default plot.
  p <- SCpubr::do_TermEnrichmentPlot(enriched_terms = enriched_terms)
  p

  # Increased number of terms.
  p <- SCpubr::do_TermEnrichmentPlot(enriched_terms = enriched_terms,
                                     nterms = 15)
  p

  # Control the length of the terms.
  p1 <- SCpubr::do_TermEnrichmentPlot(enriched_terms = enriched_terms,
                                      nterms = 15)
  p2 <- SCpubr::do_TermEnrichmentPlot(enriched_terms = enriched_terms,
                                      nterms = 15,
                                      nchar_wrap = 30)
  p <- p1 / p2
  p

  # Modify font size of the terms.
  p1 <- SCpubr::do_TermEnrichmentPlot(enriched_terms = enriched_terms)
  p2 <- SCpubr::do_TermEnrichmentPlot(enriched_terms = enriched_terms,
                                      text_labels_size = 6)

  p <- p1 / p2
  p
}
}
