% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one2one_f.R
\name{one2one_f}
\alias{one2one_f}
\title{Maximum number of unique one-to-one association over a number of runs}
\usage{
one2one_f(
  HS,
  reps = 10000,
  interval = NULL,
  strat = "sequential",
  cl = 1,
  plot = TRUE
)
}
\arguments{
\item{HS}{Host-symbiont association matrix.}

\item{reps}{Number of runs to evaluate.}

\item{interval}{Vector with the minimum and maximum \code{n} that the user
wants to test. Default is \code{"NULL"}, where a minimum \code{n}
(10% of the total associations) and a maximum \code{n} (20% of the
total associations) are automatically assigned.}

\item{strat}{Flag indicating whether execution is to be  \code{"sequential"}
or \code{"parallel"}. Default is \code{"sequential"},
resolves \R expressions sequentially in the current \R
process. If \code{"parallel"} resolves \R expressions in parallel in
separate \R sessions running in the background.}

\item{cl}{Number of cluster to be used for parallel computing.
\code{\link[parallelly:availableCores]{parallelly::availableCores()}}
returns the number of clusters available.
Default is \code{cl = 1} resulting in \code{"sequential"} execution.}

\item{plot}{Default is \code{"TRUE"}, plots the number of unique host-
symbiont associations in the \code{"interval"} range against the
number of runs that could be completed.}
}
\value{
The maximum number of unique one-to-one associations
        (\code{n}).
}
\description{
For a binary matrix of host-symbiont associations, it finds the maximum
number of host-symbiont pairs, \code{n}, for which one-to-one unique
associations can be chosen.
}
\section{NOTE}{

         It can be used to decide the best \code{n} prior to application of
         \code{\link[=max_cong]{max_cong()}}.
}

\examples{
N = 10  #for the example, we recommend 1e+4 value
data(amph_trem)
n <- one2one_f(am_matrix, reps = N, interval = c(2, 10), plot = TRUE)

}
