\name{visualize}
\alias{visualize}
\alias{visualize.coords}
\alias{visualize.data.frame}
\alias{visualize.matrix}
\alias{visualize.atoms}
\alias{visualize.pdb}
\alias{visualize.character}
\title{Visualize a Molecular Structure}
\description{Use the rgl library to visualize in 3D a molecular structure.}
\usage{
visualize(...)

\method{visualize}{coords}(x, elename = NULL, cryst1 = NULL, conect = NULL, mode = NULL,
type = "l", xyz = NULL, abc = NULL, pbc.box = NULL, lwd = 2,
lwd.xyz = lwd, lwd.abc = lwd, lwd.pbc.box = lwd,
cex.xyz = 2, cex.abc = 2, col = NULL, bg = "#FAFAD2",  radii = "rvdw",
add = FALSE, windowRect = c(0,0,800,600), FOV = 0, userMatrix=diag(4), ...)

\method{visualize}{data.frame}(x, elename = NULL, cryst1 = NULL, conect = NULL, mode = NULL,
type = "l", xyz = NULL, abc = NULL, pbc.box = NULL, lwd = 2,
lwd.xyz = lwd, lwd.abc = lwd, lwd.pbc.box = lwd,
cex.xyz = 2, cex.abc = 2, col = NULL, bg = "#FAFAD2",  radii = "rvdw",
add = FALSE, windowRect = c(0,0,800,600), FOV = 0, userMatrix=diag(4), ...)

\method{visualize}{matrix}(x, elename = NULL, cryst1 = NULL, conect = NULL, mode = NULL,
type = "l", xyz = NULL, abc = NULL, pbc.box = NULL, lwd = 2,
lwd.xyz = lwd, lwd.abc = lwd, lwd.pbc.box = lwd,
cex.xyz = 2, cex.abc = 2, col = NULL, bg = "#FAFAD2",  radii = "rvdw",
add = FALSE, windowRect = c(0,0,800,600), FOV = 0, userMatrix=diag(4), ...)

\method{visualize}{atoms}(x, cryst1 = NULL, conect = NULL, mode = NULL,
type = "l", xyz = NULL, abc = NULL, pbc.box = NULL, lwd = 2,
lwd.xyz = lwd, lwd.abc = lwd, lwd.pbc.box = lwd,
cex.xyz = 2, cex.abc = 2, col = NULL, bg = "#FAFAD2",  radii = "rvdw",
add = FALSE, windowRect = c(0,0,800,600), FOV = 0, userMatrix=diag(4), ...)
                              
\method{visualize}{pdb}(x, mode = NULL, type = "l",
xyz = NULL, abc = NULL, pbc.box = NULL, lwd = 2,
lwd.xyz = lwd, lwd.abc = lwd, lwd.pbc.box = lwd,
cex.xyz = 2, cex.abc = 2, col = NULL, bg = "#FAFAD2",  radii = "rvdw",
add = FALSE, windowRect = c(0,0,800,600), FOV = 0, userMatrix=diag(4), ...)

\method{visualize}{character}(x, mode = NULL, type = "l",
xyz = NULL, abc = NULL, pbc.box = NULL, lwd = 2,
lwd.xyz = lwd, lwd.abc = lwd, lwd.pbc.box = lwd,
cex.xyz = 2, cex.abc = 2, col = NULL, bg = "#FAFAD2",  radii = "rvdw",
add = FALSE, windowRect = c(0,0,800,600), FOV = 0, userMatrix=diag(4), ...)
}
\arguments{
  \item{x}{an object or the name of a PDB file containing the molecular structure to visualize.}
  \item{elename}{a character vector containing the atomic names used to chose atom colors and radii.}
  \item{cryst1}{an object of class \sQuote{cryst1}. See \code{\link{cryst1}}}
  \item{conect}{an object of class \sQuote{conect}. See \code{\link{conect}}}
  \item{mode}{a single element character vector indicating the visualization mode (See details).}
  \item{type}{a character string indicating the visualization style (See details).}
  \item{xyz}{a logical value indicating whether the x, y and z axes have to be added to the scene. See details}
  \item{abc}{a logical value indicating whether the a, b and c axes have to be added to the scene. See details}
  \item{pbc.box}{a logical value indicating whether the pbc box has to be added to the scene. See details}
  \item{lwd}{a numeric value indication the line width used to plot the axes, the pbc box and atomic bonds when \code{type = "l"} (see details).}
  \item{lwd.xyz}{a numeric value indicating the line width used to plot the x, y and z axes.}
  \item{lwd.abc}{a numeric value indicating the line width used to plot the a, b and c axes.}
  \item{lwd.pbc.box}{a numeric value indicating the line width used to plot the pbc box.}
  \item{cex.xyz}{a numeric value indicating the magnification used to plot the labels of the x, y and z axes.}
  \item{cex.abc}{a numeric value indicating the magnification used to plot the labels of the a, b and c axes.}
  \item{col}{a vector indicating the colors to use to plot each atom.}
  \item{bg}{the color of the background}
  \item{radii}{either a character string indicating the type of radii or a numeric vector specifying the radii of each atom to use to plot atoms as spheres (see details).}
  \item{add}{a logical value indicating whether the plot has be to added to a existing scene (see \code{rgl.cur} and \code{open3d}).}
  \item{windowRect}{a vector of four integers indicating the left, top, right and bottom of the displayed window in pixels (see \code{par3d}).}
  \item{FOV}{the field of view. This controls the degree of parallax in the perspective view (see par3d).}
  \item{userMatrix}{a 4 by 4 matrix describing user actions to display the scene (see \code{par3d}).}
  \item{\dots}{further arguments passed to or from other methods.}
}
\details{
Three different visualization styles are allowed.
\itemize{
  \item   When \code{type="p"}: Points are drawn at each atomic positions (very light visualization mode).
  \item   When \code{type="l"}: Lines are drawn between bonded atoms. The connectivity of the system has to be specifyed.
  \item   When \code{type="s"}: Spheres are drawn at each atomic positions (heavy visualization mode).
  
  The radii of the spheres are given by \code{radii}.
  \itemize{
    \item   When \code{radii="rcov"}: Covalent radii, taken from the \code{elements} data set, are used.
    \item   When \code{radii="rvdw"}: Van der Waals radii, taken from the \code{elements} data set, are used.
    \item   When \code{radii} is a numeric vector: The numeric values are used to assign to each atom a radius. If \code{length(radii) != natom(pdb)} \code{radii} is recycled.
  }
}
When \code{xyz}, \code{abc} or \code{pbc.box} are \code{NULL}, the axis or pbc box are are added depending if a \sQuote{cryst1} object can be found.\cr
Two different interactive visualization modes are avalable:
\itemize{
  \item When \code{mode="measure"}: bond lengths, angles and dihedrals can be measured by \bold{right-clicing} on the atoms.
  \item When \code{mode="info"}: atomic labels can be added to the scene by \bold{right-clicing} on the atoms. The labels are as follow: "ResidResname:EleidElename"
}
When \code{mode=NULL} the interactive mode is disabled. To escape the interactive mode press the ESC key.
}
\value{
Return (using invisible) a two-column data.frame containing the IDs
and type indicators of the objects added to the scene.
}

\seealso{
\code{\link{addXYZ}}, \code{\link{addABC}}, \code{\link{addPBCBox}}, \code{par3d}, \code{select3d}, \code{measure}, \code{info3d}
}
\examples{
x <- read.pdb(system.file("examples/PCBM_ODCB.pdb",package="Rpdb"))
visualize(x, type = "l", mode = NULL)
visualize(x, type = "s", radii = "rcov", mode = NULL)
visualize(x, type = "s", radii = "rvdw", mode = NULL)
visualize(x, type = "p", mode = NULL)
visualize(subset(x, resid != 1), type = "l", mode = NULL)
visualize(subset(x, resid == 1), type = "s", add = TRUE, mode = NULL)
}
\keyword{ dynamic }

