% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Discretization.R
\name{D.global.discernibility.heuristic.RST}
\alias{D.global.discernibility.heuristic.RST}
\title{Supervised discretization based on the maximum discernibility heuristic}
\usage{
D.global.discernibility.heuristic.RST(decision.table, maxNOfCuts = 2 *
  ncol(decision.table), attrSampleSize = ncol(decision.table) - 1,
  cutCandidatesList = NULL, discFunction = global.discernibility, ...)
}
\arguments{
\item{decision.table}{an object inheriting from the \code{"DecisionTable"} class, which represents a decision system.
See \code{\link{SF.asDecisionTable}}.
It should be noted that especially for this method, all conditional attributes
must in real values. So, in the case we have mixed values, we should choose other methods.}

\item{maxNOfCuts}{a positive integer indicating the maximum number of allowed cuts.}

\item{attrSampleSize}{an integer between 1 and the number of conditional attributes (the default). It indicates
the attribute sample size for the Monte Carlo selection of candidating cuts.}

\item{cutCandidatesList}{an optional list containing candidates for optimal cut values.}

\item{discFunction}{a function used for computation of cuts. Currently only one implementation of maximu discernibility heuristic
is available (the default). However, this parameter can be used to integrate custom implementations of
discretization functions with the \code{RoughSets} package.}

\item{...}{additional parameters to the \code{discFunction} (currently unsupported).}
}
\value{
An object of a class \code{"Discretization"} which stores cuts for each conditional attribute.
        See \code{\link{D.discretization.RST}}.
}
\description{
It is a function used for computing globally semi-optimal cuts using the maximum discernibility heuristic.
}
\details{
A complete description of the implemented algorithm can be found in (Nguyen, 2001).

It should be noted that the output of this function is an object of a class \code{"Discretization"}
which contains the cut values.
The function \code{\link{SF.applyDecTable}} has to be used in order to generate the new (discretized) decision table.
}
\examples{
#################################################################
## Example: Determine cut values and generate new decision table
#################################################################
data(RoughSetData)
wine.data <- RoughSetData$wine.dt
cut.values <- D.global.discernibility.heuristic.RST(wine.data)

## generate a new decision table:
wine.discretized <- SF.applyDecTable(wine.data, cut.values)
dim(wine.discretized)
lapply(wine.discretized, unique)

## remove attributes with only one possible value:
to.rm.idx <- which(sapply(lapply(wine.discretized, unique), function(x) length(x) == 1))
to.rm.idx
wine.discretized.reduced <- wine.discretized[-to.rm.idx]
dim(wine.discretized.reduced)

## check whether the attributes in the reduced data are a super-reduct of the original data:
colnames(wine.discretized.reduced)
class.idx <- which(colnames(wine.discretized.reduced) == "class")
sum(duplicated(wine.discretized.reduced)) == sum(duplicated(wine.discretized.reduced[-class.idx]))
## yes it is
}
\author{
Andrzej Janusz
}
\references{
S. H. Nguyen, "On Efficient Handling of Continuous Attributes in Large Data Bases",
Fundamenta Informaticae, vol. 48, p. 61 - 81 (2001).
}
\seealso{
\code{\link{D.discretize.quantiles.RST}}, \code{\link{D.discretize.equal.intervals.RST}}
         and \code{\link{SF.applyDecTable}}.
}

