\name{RI.GFRS.FRST}
\alias{RI.GFRS.FRST}
\title{Generalized fuzzy rough set rule induction based on FRST}
\usage{
  RI.GFRS.FRST(decision.table, control = list())
}
\arguments{
  \item{decision.table}{a \code{"DecisionTable"} class
  representing the decision table. See
  \code{\link{SF.asDecisionTable}}.}

  \item{control}{a list of other parameters which consist
  of \itemize{ \item \code{alpha.precision}: a numeric
  value representing variable precision of FVPRS.  The
  default value is 0.05. See
  \code{\link{BC.LU.approximation.FRST}}.  \item
  \code{type.aggregation}: a list of a type of
  aggregations. The default value is \code{type.aggregation
  = c("t.tnorm", "lukasiewicz")}.

  See \code{\link{BC.IND.relation.FRST}}.  \item
  \code{type.relation}: a type of indiscernibility
  relation. The default value is \code{type.relation =
  c("tolerance", "eq.1")}.  See
  \code{\link{BC.IND.relation.FRST}}.  \item
  \code{t.implicator}: a type of implication function. The
  default value is \code{"lukasiewicz"}.  See
  \code{\link{BC.LU.approximation.FRST}}.  }}
}
\value{
  A class \code{"RuleSetFRST"} which has following
  components: \itemize{ \item \code{rules}: It is a list
  containing two elements which are \code{rules} and
  \code{threshold}.  The \code{rules} represent knowledge
  in dataset that can be expressed as an IF-THEN form.  For
  example, we got the rule as follows: \code{90 8 2} and
  its colnames: \code{pres}, \code{preg}, and \code{class}.
  It refers to the following rule: \code{IF pres is about
  90 and preg is about 8 THEN class is 2}.  In other words,
  while the last column represents the consequent part, the
  rest expresses the antecedent part.  The second part of
  this object is \code{threshold} representing a value used
  to predict new data.  In order to change IF-THEN form, we
  can use \code{\link{summary}}. \item \code{type.model}:
  It is the type of the theory whether \code{"FRST"} or
  \code{"RST"}. In this case, it is \code{FRST}. \item
  \code{type.method}: It is the considered method. In this
  case, it is \code{RI.GFRS.FRST}. \item \code{type.task}:
  It is the type of task. In this case, it is
  \code{"classification"}. \item \code{t.similariy}: It is
  the type of similarity equation. See
  \code{\link{BC.IND.relation.FRST}}. \item \code{t.tnorm}:
  It is the type of triangular operator. See
  \code{\link{BC.IND.relation.FRST}}. \item
  \code{variance.data}: It represents the variance of the
  dataset. It has \code{NA} values when the associated
  attributes are nominal values. \item \code{range.data}:
  It represents the range of the dataset. It has \code{NA}
  values when the associated attributes are nominal values.
  \item \code{antecedent.attr}: It is a list of attribute
  names involved in the antecedent part. \item
  \code{consequent.attr}: It is the attribute in the
  consequent part. \item \code{nominal.att}: It is a list
  of boolean that represent whether a attribute is nominal
  or not. }
}
\description{
  It is a function generating rules in classification tasks
  using the fuzzy variable precision rough sets (FVPRS)
  approach (see \code{\link{BC.LU.approximation.FRST}}).
}
\details{
  The method proposed by (S. Y. Zhao, 2010) consists of
  three steps as follows. First, it builds a general lower
  approximation that is able to deal with misclassification
  and perturbation. In this case, the fuzzy variable
  precision rough sets (FVPRS) is used to calculate the
  lower approximation (see
  \code{\link{BC.LU.approximation.FRST}}). Secondly, a
  discernibility matrix considering a consistence degree is
  constructed for obtaining rules. The details about the
  matrix can be seen in
  \code{\link{BC.discernibility.mat.FRST}}. Then, we
  calculate attribute value reduction of every object and
  perform near-minimal rule set. The final step is to
  construct rules considering the consistence degree of
  associated objects.

  It should be noted that this function only allows
  classification problems. After obtaining the rules,
  predicting can be done by calling \code{predict} or
  \code{\link{predict.RuleSetFRST}}. Additionally, to get
  better representation we can execute
  \code{\link{summary}}.
}
\examples{
###########################################################
## Example
##############################################################
data(RoughSetData)
decision.table <- RoughSetData$pima7.dt

control <- list(alpha.precision = 0.01, type.aggregation = c("t.tnorm", "lukasiewicz"),
                type.relation = c("tolerance", "eq.3"), t.implicator = "lukasiewicz")
rules <- RI.GFRS.FRST(decision.table, control)
}
\references{
  S. Y. Zhao, E. C. C. Tsang, D. G. Chen, and X. Z. Wang,
  "Building a Rule-based Classifier -- A Fuzzy-rough Set
  Approach", IEEE Trans. on Knowledge and Data Engineering,
  vol. 22, no. 5, p. 624 - 638 (2010).
}
\seealso{
  \code{\link{RI.indiscernibilityBasedRules.RST}},
  \code{\link{predict.RuleSetFRST}}, and
  \code{\link{RI.hybridFS.FRST}}.
}

