% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriorSamplesToParametricPrior.R
\name{posteriorSamplesToParametricPrior}
\alias{posteriorSamplesToParametricPrior}
\title{Priors from MCMC samples}
\usage{
posteriorSamplesToParametricPrior(
  samples,
  distribution,
  variance_inflation_factor = 2
)
}
\arguments{
\item{samples}{(numeric vector; no default) MCMC samples for a single
parameter.}

\item{distribution}{(character; no default) The distribution to fit. Options
are gamma for strictly positive
parameters and normal for unbounded parameters.}

\item{variance_inflation_factor}{(single numeric value; default = 2.0) Makes
the prior variance larger than the variance of the posterior}
}
\value{
Numeric vector of parameters with names (to avoid rate/scale and
var/sd confusion).
}
\description{
Turn posterior samples collected by MCMC into a parametric prior
distribution.
}
\details{
The distributions are fit by the method of moments.
The function allows inflating the prior variance relative to the posterior
being supplied.
}
\examples{

\donttest{
# download the example datasets to working directory

url_ex_times <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_extinction_times.log"
dest_path_ex_times <- "primates_EBD_extinction_times.log"
download.file(url_ex_times, dest_path_ex_times)

url_ex_rates <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_extinction_rates.log"
dest_path_ex_rates <- "primates_EBD_extinction_rates.log"
download.file(url_ex_rates, dest_path_ex_rates)

url_sp_times <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_speciation_times.log"
dest_path_sp_times <- "primates_EBD_speciation_times.log"
download.file(url_sp_times, dest_path_sp_times)

url_sp_rates <-
   "https://revbayes.github.io/tutorials/intro/data/primates_EBD_speciation_rates.log"
dest_path_sp_rates <- "primates_EBD_speciation_rates.log"
download.file(url_sp_rates, dest_path_sp_rates)

# to run on your own data, change this to the path to your data file
speciation_time_file <- dest_path_sp_times
speciation_rate_file <- dest_path_sp_rates
extinction_time_file <- dest_path_ex_times
extinction_rate_file <- dest_path_ex_rates

primates <- processDivRates(speciation_time_log = speciation_time_file,
                            speciation_rate_log = speciation_rate_file,
                            extinction_time_log = extinction_time_file,
                            extinction_rate_log = extinction_rate_file,
                            burnin = 0.25)

speciation_rates <-
       dplyr::pull(primates[which(primates$item == "speciation rate"),],
                  "value")
speciation_1_gamma_prior <-
          posteriorSamplesToParametricPrior(speciation_rates,"gamma")

# remove files
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path_sp_times, dest_path_ex_times,
            dest_path_sp_rates, dest_path_ex_rates)
}

}
