% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processSSE.R
\name{processSSE}
\alias{processSSE}
\title{Title}
\usage{
processSSE(
  path,
  speciation = "speciation",
  extinction = "extinction",
  speciation_hidden = "speciation_hidden",
  rates = c(speciation, extinction, "net-diversification"),
  ...
)
}
\arguments{
\item{path}{(vector of character strings; no default) File path(s) to
trace file.}

\item{speciation}{(single character string; "speciation") RevBayes variable
name}

\item{extinction}{(single character string; "extinction") RevBayes variable
name}

\item{speciation_hidden}{(single character string; "speciation_hidden")
RevBayes variable name}

\item{rates}{(vector; c(speciation, extinction, "net-diversification"))
names of rates to be included in plot}

\item{...}{additional arguments passed to readTrace()}
}
\value{
a data frame
}
\description{
Title
}
\examples{

\donttest{
# download the example dataset to working directory

url <-
  "https://revbayes.github.io/tutorials/intro/data/primates_BiSSE_activity_period.log"
dest_path <- "primates_BiSSE_activity_period.log"
download.file(url, dest_path)

# to run on your own data, change this to the path to your data file
bisse_file <- dest_path

pdata <- processSSE(bisse_file)

# remove file
# WARNING: only run for example dataset!
# otherwise you might delete your data!
file.remove(dest_path)
}

}
