% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResIN_to_igraph.R
\name{ResIN_to_igraph}
\alias{ResIN_to_igraph}
\title{ResIN_to_igraph}
\usage{
ResIN_to_igraph(ResIN_object, igraph_arglist = NULL)
}
\arguments{
\item{ResIN_object}{the output of the ResIN function (a list with class ResIN).}

\item{igraph_arglist}{an optional argument list to be supplied to the igraph::graph_from_adjacency_matrix function. If NULL, default is: list(mode = "undirected", weighted = TRUE, diag = FALSE).}
}
\value{
A class \code{igraph} object.
}
\description{
Transforms the output of the ResIN function into an [igraph](https://igraph.org/r/doc/cluster_leading_eigen.html) object
}
\examples{

## Load the 12-item simulated Likert-type ResIN toy dataset
data(lik_data)

## Run the function:
\donttest{
igraph_output <-  ResIN_to_igraph(ResIN(lik_data))


## Plot and/or investigate as you wish:
igraph::plot.igraph(igraph_output)
}

}
\references{
Csardi G, Nepusz T (2006). “The igraph software package for complex network research.” InterJournal, Complex Systems, 1695. https://igraph.org.
}
