thisFilename <- "test-1packages.R"
startTime <- Sys.time()
message("\033[32m --------------------------------- Starting ",thisFilename,"  at: ",format(startTime),"---------------------------\033[39m")
Require:::messageVerbose("\033[34m getOption('Require.verbose'): ", getOption("Require.verbose"), "\033[39m", verboseLevel = 0)
Require:::messageVerbose("\033[34m getOption('repos'): ", paste(getOption("repos"), collapse = ", "), "\033[39m", verboseLevel = 0)

origLibPathsAllTests <- .libPaths()

Sys.setenv("R_REMOTES_UPGRADE" = "never")
Sys.setenv("CRANCACHE_DISABLE" = TRUE)
outOpts <- options("Require.persistentPkgEnv" = TRUE,
                   "install.packages.check.source" = "never",
                   "install.packages.compile.from.source" = "never",
                   "Require.unloadNamespaces" = TRUE)
if (Sys.info()["user"] == "achubaty") {
  outOpts2 <- options("Require.Home" = "~/GitHub/PredictiveEcology/Require")
} else {
  outOpts2 <- options("Require.Home" = "~/GitHub/Require")
}

### cover CRAN in case of having a environment variable set, which TRAVIS seems to
origCRAN_REPO <- Sys.getenv("CRAN_REPO")
Sys.setenv("CRAN_REPO" = "")
isInteractive <- function() FALSE
assignInNamespace("isInteractive", isInteractive, ns = "Require")
out <- Require:::getCRANrepos("")
Sys.setenv("CRAN_REPO" = origCRAN_REPO)

repos <- Require:::getCRANrepos("")
testit::assert({is.character(repos)})
testit::assert({nchar(repos) > 0})

#repos <- NULL
#chooseCRANmirror(ind = 1)
#repos <- getOption("repos")

options("Require.purge" = FALSE)

# Failure on Travis:
# cannot open file 'startup.Rs': No such file or directory
# suggested solution https://stackoverflow.com/a/27994299/3890027
Sys.setenv("R_TESTS" = "")
Sys.setenv("R_REMOTES_UPGRADE" = "never")

library(testit)

dir1 <- Require:::rpackageFolder(Require::tempdir2("test1"))
Require::checkPath(dir1, create = TRUE)
out <- Require::Require("fpCompare (<= 1.2.3)", standAlone = TRUE, libPaths = dir1, verbose = 2)
testit::assert({data.table::is.data.table(attr(out, "Require"))})
testit::assert({isTRUE(out)})
isInstalled <- tryCatch({
  out <- find.package("fpCompare", lib.loc = dir1)
  if (length(out)) TRUE else FALSE
}, error = function(x) FALSE)
testit::assert({isTRUE(isInstalled)})
out <- detachAll(c("Require", "fpCompare", "sdfd"), dontTry = "testit")
out <- out[names(out) != "testit"]
expectedPkgs <- c(sdfd = 3, fpCompare = 2, Require = 1, data.table = 1)
keep <- intersect(names(expectedPkgs), names(out))
out <- out[keep]
testit::assert({identical(sort(out), sort(expectedPkgs))})
testit::assert({names(out)[out == 2] == "fpCompare"})

# detach("package:fpCompare", unload = TRUE)
remove.packages("fpCompare", lib = dir1)

# Try older version
if (identical(tolower(Sys.getenv("CI")), "true") ||  # travis
    interactive() || # interactive
    identical(Sys.getenv("NOT_CRAN"), "true")) { # CTRL-SHIFT-E
  dir2 <- Require:::rpackageFolder(Require::tempdir2("test2"))
  Require::checkPath(dir2, create = TRUE)
  pvWant <- "0.2.2"
  inst <- Require::Require(paste0("fpCompare (<=", pvWant, ")"), standAlone = TRUE,
                           libPaths = dir2, dependencies = FALSE, require = FALSE)
  pv <- packageVersion("fpCompare", lib.loc = dir2)
  testit::assert({pv == pvWant})

  # Test snapshot file
  orig <- setLibPaths(dir2, standAlone = TRUE, updateRprofile = FALSE)
  pkgSnapFile <- tempfile()
  pkgSnapshot(pkgSnapFile, .libPaths()[-length(.libPaths())])
  pkgSnapFileRes <- data.table::fread(pkgSnapFile)

  dir6 <- Require:::rpackageFolder(Require::tempdir2("test6"))
  Require::checkPath(dir6, create = TRUE)
  out <- Require::Require(packageVersionFile = pkgSnapFile, libPaths = dir6,
                          install = "force")
  testit::assert({identical(packageVersion("fpCompare", lib.loc = dir2),
                            packageVersion("fpCompare", lib.loc = dir6))})
  remove.packages("fpCompare", lib = dir2)
  remove.packages("fpCompare", lib = dir6)

  setLibPaths(orig, updateRprofile = FALSE)

  # Test snapshot file with no args
  prevDir <- setwd(Require::tempdir2("test11"))
  out <- pkgSnapshot()
  pkgSnapFileRes <- data.table::fread(formals("pkgSnapshot")$packageVersionFile)
  testit::assert({is.data.frame(out)})
  testit::assert({file.exists(formals("pkgSnapshot")$packageVersionFile)})
  out1 <- data.table::as.data.table(out)
  testit::assert({isTRUE(all.equal(out1, pkgSnapFileRes))})
  setwd(prevDir)

  # Skip on CRAN
  dir3 <- Require:::rpackageFolder(Require::tempdir2(Require:::.rndstr(1)))
  Require::checkPath(dir3, create = TRUE)
  dir.create(dir3, recursive = TRUE, showWarnings = FALSE)
  #try({
  inst <- Require::Require("achubaty/fpCompare", install = "force", verbose = 2,
                             require = FALSE, standAlone = TRUE, libPaths = dir3)
  attrOut <- capture.output(type = "message", Require:::messageDF(attr(inst, "Require")))
  #}, silent = TRUE)
  pkgs <- c("fpCompare")

  isInstalled <- tryCatch( {
    out <- find.package(pkgs, lib.loc = dir3)
    if (length(out)) TRUE else FALSE
  }, error = function(x) FALSE)
  testit::assert({isTRUE(isInstalled)})

  # Try github with version
  dir4 <- Require:::rpackageFolder(Require::tempdir2("test4"))
  silent <- Require::checkPath(dir4, create = TRUE)
  inst <- Require::Require("achubaty/fpCompare (>=2.0.0)",
                           require = FALSE, standAlone = FALSE, libPaths = dir4)
  testit::assert({isFALSE(inst)})
  mess <- utils::capture.output({
    inst <- Require::Require("achubaty/fpCompare (>=2.0.0)", verbose = 1,
                             require = FALSE, standAlone = FALSE, libPaths = dir4)
  }, type = "message")
  testit::assert({length(mess) > 0})
  testit::assert({sum(grepl("could not be installed", mess)) == 1})
  unlink(dirname(dir3), recursive = TRUE)
  unlink(dirname(dir4), recursive = TRUE)
}

# Code coverage -- run 2x so it won't reinstall
# This line fails on CRAN testing for some reason; not on GA x9, E x3, A x1, WinBuilder x3, IE etc.

try(mess1 <- capture.output(type = "message",
                            out1 <- installGitHubPackage("PredictiveEcology/peutils@master", verbose = 2)),
    silent = TRUE)
try(mess2 <- capture.output(type = "message",
                            out2 <- installGitHubPackage("PredictiveEcology/peutils@master", verbose = 2)),
    silent = TRUE)

# Code coverage
pkg <- c("rforge/mumin/pkg", "Require")
names(pkg) <- c("MuMIn", "")
out <- Require(pkg, install = FALSE, require = FALSE)
testit::assert({isFALSE(all(out))})

# Try a package taken off CRAN
reallyOldPkg <- "ggplot"
out <- Require(reallyOldPkg, require = FALSE)
ip <- data.table::as.data.table(installed.packages())
testit::assert(NROW(ip[Package == reallyOldPkg]) == 1)

out <- getPkgVersions("Require")
testit::assert({data.table::is.data.table(out)})
testit::assert({is.na(out$correctVersion)})
out2 <- getAvailable(out)
testit::assert({is.na(out2$correctVersion)})
out3 <- tryCatch({
  out2 <- installFrom(out2)
}, error = function(condition) condition)
testit::assert({is(out3, "simpleError")})
out2[, installed := TRUE]
out3 <- installFrom(out2)
testit::assert({is.na(out3$correctVersion)})
testit::assert({is.na(out3$installFrom)})
testit::assert({is.na(out3$needInstall)})

out <- getGitHubDESCRIPTION(data.table::data.table(packageFullName = "rforge/mumin/pkg"))
testit::assert({data.table::is.data.table(out)})
testit::assert({!is.null(out$DESCFile)})
testit::assert({file.exists(out$DESCFile)})

out <- getGitHubDESCRIPTION(pkg = character())
testit::assert({length(out) == 0})

# Trigger the save available.packages and archiveAvailable
# warn <- tryCatch(out <- Require("Require (>=0.0.1)", dependencies = FALSE,
#                                 install = "force"),
#                  error = function(x) x)
# warn <- tryCatch(out <- Require("Require (>=0.0.1)", dependencies = FALSE,
#                                 install = "force"),
#                  error = function(x) x)
if (interactive()) {
  warn <- tryCatch({
    out <- Require("A3 (<=0.0.1)", dependencies = FALSE, install = "force")
  }, warning = function(x) x)
  warn <- tryCatch({
    out <- Require("A3 (<=0.0.1)", dependencies = FALSE, install = "force")
  }, warning = function(x) x)
}

# options(opt)
options(outOpts)
if (exists("outOpts2")) options(outOpts2)
if (!identical(origLibPathsAllTests, .libPaths()))
  Require::setLibPaths(origLibPathsAllTests, standAlone = TRUE, exact = TRUE)
endTime <- Sys.time()
message("\033[32m ----------------------------------",thisFilename, ": ", format(endTime - startTime)," \033[39m")
