% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{KO_sea}
\alias{KO_sea}
\title{Perform Simultaneous Enrichment Analysis}
\usage{
KO_sea(reporter_res, verbose = TRUE, ...)
}
\arguments{
\item{reporter_res}{The input reporter result.}

\item{verbose}{If TRUE, print verbose messages. Default is TRUE.}

\item{...}{Additional parameters to be passed to \code{\link[rSEA]{SEA}} function.}
}
\value{
enrich_res
}
\description{
Perform Simultaneous Enrichment Analysis
}
\examples{
\donttest{
## use `SEA` from the `rSEA` package.
if (requireNamespace("rSEA")) {
  data("reporter_score_res")
  sea_res <- KO_sea(reporter_score_res, verbose = TRUE)
}
}
}
\seealso{
Other common_enrich: 
\code{\link{KO_enrich}()},
\code{\link{KO_fisher}()},
\code{\link{KO_gsa}()},
\code{\link{KO_gsea}()},
\code{\link{KO_gsva}()},
\code{\link{KO_padog}()},
\code{\link{KO_safe}()},
\code{\link{plot_enrich_res}()}
}
\concept{common_enrich}
