% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imperfect_competition.R
\name{monopoly_solver}
\alias{monopoly_solver}
\title{Monopoly Profit Maximization}
\usage{
monopoly_solver(cost = c(0, 1, 0), demand = c(0, -1, 0), q0 = 0)
}
\arguments{
\item{cost}{a vector of cost curve coefficients, which must be in order: intercept of the cost function, linear term's parameter of the cost function and quadratic term's parameter of the cost function}

\item{demand}{a vector of demand curve coefficients, which must be in order: intercept of inverse demand function, linear coefficient, secon degree coefficient}

\item{q0}{Initial guess for monopolist's output. Defaults to 0. Strongly advise not to set this parameter unless you are very aware of what you're doing.}
}
\value{
A list with market price, output, profits, markup, profitrate.
}
\description{
This function numerically finds the profit-maximizing output for a monopolist with linear and non-linear cost and demand curves. For guaranteed existence of feasible solution (in which both price and output are positive), a linear demand curve might be necessary.
}
\examples{


c = c(50, 3, 1)
p = c(500, -8, -1)
monopoly_solver(cost = c, demand = p)

}
\author{
Pedro Cavalcante Oliveira, Department of Economics, Fluminense Federal University \email{pedrocolrj@gmail.com}
}
