\name{insert_ref}
\alias{insert_ref}
\alias{insertRef}
\title{Insert bibtex references in Rd and roxygen documentation}
\description{

  Include references from bibtex files into R documentation using a
  macro.  Function \code{insert_ref} is called behind the scenes at
  package built time.

}
\usage{
insert_ref(key, package = NULL, ...)
}
\arguments{
  \item{key}{the bibtex key of the reference, a character string.}
  \item{package}{the package in which to look for the the bibtex file.}
  \item{\dots}{further arguments to pass on to \code{bibtex::read.bib}}
}
\details{
  \code{insert_ref} extracts a reference from a bibtex file, converts
  it to Rd format and returns a single string with embedded newline
  characters. It is the workhorse in the provided mechanism but most
  users do not even need to know about \code{insert_ref}.


  To insert references from a bibtex file in your package:
  \enumerate{
    \item{
      add the following line to file `DESCRIPTION':

      \verb{RdMacros: Rdpack}

      (If the field 'RdMacros' is already present, add Rdpack to the
      list on that line.)
    }

    \item{
      Create file \code{"REFERENCES.bib"} in subdirectory \code{"inst/"} of your
      package and put your bibtex references in it.
    }

  }

  Then you can insert references in the documentation with
  \verb{\\insertRef{key}{package}}, where \verb{key} is the bibtex key of
  the reference and \verb{package} is an R package.

  This works in manually written Rd files and in roxygen documentation
  chunks. The references will appear in the place where you put the
  macro, usually in a dedicated references section (\verb{\\references}
  in Rd files, \verb{@references} in roxygen chunks).


  Argument 'package' can be any installed R package, not necessarily the
  current one. This means that you don't need to copy references from
  other packages to your \code{"REFERENCES.bib"} file.  This works for
  packages that have \code{"REFERENCES.bib"} in their installation
  directory and for the default packages.

  For example, the references in the references section of this help
  page are generated by the following lines in the Rd file:
  \preformatted{
    \\insertRef{Rpack:bibtex}{Rdpack}

    \\insertRef{R}{bibtex}
  }

  A roxygen documentation chunk might look like this:
  \preformatted{
    #' \@references
    #' \\insertRef{Rpack:bibtex}{Rdpack}
    #'
    #' \\insertRef{R}{bibtex}
  }

  The references are processed when the package is built. So, there is
  \emph{no need} to depend/import/suggest package \verb{"Rdpack"}, it
  only needs to be installed on your machine.




}
\value{
  for \code{insert_ref}, a character string
}
\references{
  \insertRef{Rpack:bibtex}{Rdpack}

  \insertRef{R}{bibtex}
}
\author{Georgi N. Boshnakov}
\seealso{
  \code{\link{rebib}}
}
\examples{
  insert_ref("R", package = "bibtex")

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{Rd}
