% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_PPCA.R
\name{do.ppca}
\alias{do.ppca}
\title{Probabilistic Principal Component Analysis}
\usage{
do.ppca(X, ndim = 2)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{mle.sigma2}{MLE for \eqn{\sigma^2}.}
\item{mle.W}{MLE of a \eqn{(p\times ndim)} mapping from latent to observation in column major.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Probabilistic PCA (PPCA) is a probabilistic framework to explain the well-known PCA model. Using
the conjugacy of normal model, we compute MLE for values explicitly derived in the paper. Note that
unlike PCA where loadings are directly used for projection, PPCA uses \eqn{WM^{-1}} as projection matrix,
as it is relevant to the error model. Also, for high-dimensional problem, it is possible that MLE can have
negative values if sample covariance given the data is rank-deficient.
}
\examples{
\donttest{
## use iris data
data(iris)
set.seed(100)
subid = sample(1:150, 50)
X     = as.matrix(iris[subid,1:4])
label = as.factor(iris[subid,5])

## Compare PCA and PPCA
PCA  <- do.pca(X, ndim=2)
PPCA <- do.ppca(X, ndim=2)

## Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2))
plot(PCA$Y,  pch=19, col=label, main="PCA")
plot(PPCA$Y, pch=19, col=label, main="PPCA")
par(opar)
}

}
\references{
\insertRef{tipping_probabilistic_1999}{Rdimtools}
}
\seealso{
\code{\link{do.pca}}
}
\author{
Kisung You
}
\concept{linear_methods}
