% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonlinear_LAMP.R
\name{do.lamp}
\alias{do.lamp}
\title{Local Affine Multidimensional Projection}
\usage{
do.lamp(X, ndim = 2, preprocess = c("null", "center", "scale",
  "cscale", "whiten", "decorrelate"))
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{ndim}{an integer-valued target dimension.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "null". See also \code{\link{aux.preprocess}} for more details.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
}
}
\description{
Local Affine Mulditimensional Projection (\emph{LAMP}) can be considered as
a nonlinear method even though each datam is projected using locally estimated
affine mapping. It first finds a low-dimensional embedding for control points
and then locates the rest data using affine mapping. We use \eqn{\sqrt{n}} number
of data as controls and Stochastic Neighborhood Embedding is applied as an
initial projection of control set. Note that this belongs to the method for
visualization so projection onto \eqn{\mathbf{R}^2} is suggested for use.
}
\examples{
\dontrun{
## load iris data
data(iris)
X <- as.matrix(iris[,1:4])

## let's compare with PCA
out1 <- do.pca(X, ndim=2)      # PCA
out2 <- do.lamp(X, ndim=2)     # LAMP

## visualize
par(mfrow=c(1,2))
plot(out1$Y[,1], out1$Y[,2], main="PCA")
plot(out2$Y[,1], out2$Y[,2], main="LAMP")
}

}
\references{
\insertRef{joia_local_2011}{Rdimtools}
}
\seealso{
\code{\link{do.sne}}
}
\author{
Kisung You
}
