% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_RLDA.R
\name{do.rlda}
\alias{do.rlda}
\title{Regularized Linear Discriminant Analysis}
\usage{
do.rlda(X, label, ndim = 2, alpha = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{alpha}{Tikhonow regularization parameter.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
In small sample case, Linear Discriminant Analysis (LDA) may suffer from
rank deficiency issue. Applied mathematics has used Tikhonov regularization -
also known as \eqn{\ell_2} regularization/shrinkage - to adjust linear operator.
Regularized Linear Discriminant Analysis (RLDA) adopts such idea to stabilize
eigendecomposition in LDA formulation.
}
\examples{
\dontrun{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
Y      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## try different regularization parameters
out1 <- do.rlda(Y, label, alpha=0.1)
out2 <- do.rlda(Y, label, alpha=1)
out3 <- do.rlda(Y, label, alpha=10)

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="alpha=0.1")
plot(out2$Y[,1], out2$Y[,2], main="alpha=1")
plot(out3$Y[,1], out3$Y[,2], main="alpha=10")
}

}
\references{
\insertRef{friedman_regularized_1989}{Rdimtools}
}
\author{
Kisung You
}
