% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_SSLDP.R
\name{do.ssldp}
\alias{do.ssldp}
\title{Semi-Supervised Locally Discriminant Projection}
\usage{
do.ssldp(X, label, ndim = 2, type = c("proportion", 0.1),
  preprocess = c("center", "scale", "cscale", "whiten", "decorrelate"),
  beta = 0.5)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{label}{a length-\eqn{n} vector of data class labels.}

\item{ndim}{an integer-valued target dimension.}

\item{type}{a vector of neighborhood graph construction. Following types are supported;
\code{c("knn",k)}, \code{c("enn",radius)}, and \code{c("proportion",ratio)}.
Default is \code{c("proportion",0.1)}, connecting about 1/10 of nearest data points
among all data points. See also \code{\link{aux.graphnbd}} for more details.}

\item{preprocess}{an additional option for preprocessing the data.
Default is "center". See also \code{\link{aux.preprocess}} for more details.}

\item{beta}{balancing parameter for intra- and inter-class information in \eqn{[0,1]}.}
}
\value{
a named list containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{trfinfo}{a list containing information for out-of-sample prediction.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
}
}
\description{
Semi-Supervised Locally Discriminant Projection (SSLDP) is a semi-supervised
extension of LDP. It utilizes unlabeled data to overcome the small-sample-size problem
under the situation where labeled data have the small number. Using two information,
it both constructs the within- and between-class weight matrices incorporating the
neighborhood information of the data set.
}
\examples{
## generate data of 3 types with clear difference
dt1  = aux.gensamples(n=33)-100
dt2  = aux.gensamples(n=33)
dt3  = aux.gensamples(n=33)+100

## merge the data and create a label correspondingly
Z      = rbind(dt1,dt2,dt3)
label  = c(rep(1,33), rep(2,33), rep(3,33))

## copy a label and let 10\% of elements be missing
nlabel = length(label)
nmissing = round(nlabel*0.10)
label_missing = label
label_missing[sample(1:nlabel, nmissing)]=NA

## compute with 3 different neighborhood size
out1 = do.ssldp(Z, label_missing, type=c("proportion",0.05))
out2 = do.ssldp(Z, label_missing, type=c("proportion",0.10))
out3 = do.ssldp(Z, label_missing, type=c("proportion",0.25))

## visualize
par(mfrow=c(1,3))
plot(out1$Y[,1], out1$Y[,2], main="5\% connectivity")
plot(out2$Y[,1], out2$Y[,2], main="10\% connectivity")
plot(out3$Y[,1], out3$Y[,2], main="25\% connectivity")

}
\references{
\insertRef{zhang_semi-supervised_2011}{Rdimtools}
}
\author{
Kisung You
}
