% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{rd_str_to_md}
\alias{rd_str_to_md}
\title{Translate an Rd string to markdown}
\usage{
rd_str_to_md(x, fragment = TRUE, ...)
}
\arguments{
\item{x}{Rd string. Backslashes must be double-escaped ("\\\\").}

\item{fragment}{logical indicating whether this represents a complete Rd file}

\item{...}{additional arguments for as_markdown}
}
\description{
Note that this will always end in one newline \\n.
}
\examples{
rd_str_to_md("a\n\%b\nc")

rd_str_to_md("a & b")

rd_str_to_md("\\\\strong{\\\\emph{x}}")

rd_str_to_md("\\\\enumerate{\\\\item test 1\n\n\\\\item test 2}")
rd_str_to_md("wrapped \\\\itemize{\\\\item test 1\n\\\\item test 2} in text")

}
