% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedySetCover.R
\name{greedySetCover}
\alias{greedySetCover}
\title{Greedy Set Cover}
\usage{
greedySetCover(X, data.table = TRUE)
}
\arguments{
\item{X}{Two-column data.frame in long format: Column 1 identifies the sets, column 2 the elements.}

\item{data.table}{If \code{TRUE} returns a \code{data.table} with keys given by sets and elements. 
If FALSE returns a \code{data.frame}, sorted by sets and elements.}
}
\value{
If \code{data.table == TRUE} a \code{data.table}, keyed by sets and elements. 
Else a \code{data.frame}, sorted by sets and elements. 
Column names are derived from input.
}
\description{
Fast greedy set cover algorithm.
}
\examples{
# Create some data.
set.seed(333)
X <- data.table::rbindlist(
  lapply(
    seq_len(1e4L),
    function(x) list(element=sample.int(n=1e3L,size=sample.int(50L,1L)))
  ),
  idcol="set"
)
# Elements are integers 1,2,...,1000.

# Run set cover
res <- greedySetCover(X,FALSE)
head(res)

# Check if all elements are covered.
identical(sort(unique(res$element)),sort(unique(X$element)))
}
\keyword{cover}
\keyword{greedy}
\keyword{set}
