% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{toTz}
\alias{toTz}
\title{Shift datetime object from one timezone to another}
\usage{
toTz(dt, tzfrom, tzto, verbose = FALSE)
}
\arguments{
\item{dt}{A Datetime object specifying when the difference is to be computed.}

\item{tzfrom}{The first time zone as a character vector.}

\item{tzto}{The second time zone as a character vector.}

\item{verbose}{A boolean toggle indicating whether more verbose operations
are desired, default is \code{FALSE}.}
}
\value{
A Datetime object with the given (civil time) determined by the
incoming object (and its timezone) shifted to the target timezone.
}
\description{
Change from one given timezone to another.
}
\details{
Time zone offsets vary by date, and this helper function converts
a Datetime object from one given timezone to another.
}
\examples{
\dontrun{
toTz(Sys.time(), "America/New_York", "Europe/London")
# this redoes the 'Armstrong on the moon in NYC and Sydney' example
# note that the default print method will print the return object in _your local time_
toTz(ISOdatetime(1969,7,20,22,56,0,tz="UTC"), "America/New_York", "Australia/Sydney", verbose=TRUE)
# whereas explicitly formating for Sydney time does the right thing
format(toTz(ISOdatetime(1969,7,20,22,56,0,tz="UTC"), 
            "America/New_York", "Australia/Sydney", verbose=TRUE), 
       tz="Australia/Sydney")
}
}
\author{
Dirk Eddelbuettel
}
