% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-running-quantile.R
\name{running_quantile}
\alias{running_quantile}
\title{Running Quantile Calculation}
\usage{
running_quantile(
  .x,
  .window,
  .probs = 0.5,
  .type = 7,
  .rule = "quantile",
  .align = "center"
)
}
\arguments{
\item{.x}{A numeric vector for which the running quantile is to be calculated.}

\item{.window}{An integer specifying the size of the sliding window.}

\item{.probs}{A numeric value between 0 and 1 indicating the desired quantile
probability (default is 0.50).}

\item{.type}{An integer from 1 to 9 specifying the quantile algorithm type
(default is 7).}

\item{.rule}{A character string indicating the rule to apply at the edges of
the window. Possible choices are:
\itemize{
\item "quantile": Standard quantile calculation.
\item "trim": Trims the output to remove values outside the window.
\item "keep": Keeps the original values at the edges of the window.
\item "constant": Fills the edges with the constant value from the nearest valid quantile.
\item "NA": Fills the edges with NA values.
\item "func": Applies a custom function to the values in the window (default is "quantile").
}}

\item{.align}{A character string specifying the alignment of the
window ("center", "left", or "right"; default is "center").}
}
\value{
A numeric vector containing the running quantile values.
}
\description{
The \code{running_quantile} function calculates the quantile of
a vector over a sliding window, allowing for various alignment and rule options.
}
\details{
This function computes the running quantile of a numeric vector using
a specified window size and probability.
}
\examples{
# Example usage of running_quantile
set.seed(123)
data <- cumsum(rnorm(50))
result <- running_quantile(data, .window = 3, .probs = 0.5)
print(result)

plot(data, type = "l")
lines(result, col = "red")

}
\seealso{
Other Utility Functions: 
\code{\link{confidence_interval}()},
\code{\link{convert_snake_to_title_case}()},
\code{\link{generate_caption}()},
\code{\link{get_attributes}()},
\code{\link{rand_walk_column_names}()},
\code{\link{rand_walk_helper}()},
\code{\link{std_cum_max_augment}()},
\code{\link{std_cum_mean_augment}()},
\code{\link{std_cum_min_augment}()},
\code{\link{std_cum_prod_augment}()},
\code{\link{std_cum_sum_augment}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Utility Functions}
