% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_rep.R
\name{shape_rep}
\alias{shape_rep}
\title{Calculate shape of reproduction over age}
\usage{
shape_rep(rep, xmin = NULL, xmax = NULL)
}
\arguments{
\item{rep}{Either 1) a numeric vector describing reproduction over age (mx),
  or 2) a \code{data.frame} / \code{list} with one column / element titled
  'mx' describing a reproduction over age, optionally a column / element 'x'
  containing age classes (each element a number representing the age at the
  start of the class).

  If x is not supplied, the function will assume age classes starting at 0
  with time steps of unit. If x ends at maximum longevity,
  \code{mx[which.max(x)]} should equal 0; however it is possible to supply
  partial reproduction schedules.}

\item{xmin, xmax}{The minimum and maximum age respectively over which to
evaluate shape. If not given, these default to \code{min(x)} and
\code{max(x)} respectively.}
}
\value{
a shape value describing symmetry of reproduction over age by
  comparing the area under a cumulative reproduction curve over age with the
  area under constant reproduction. May take any real value between -0.5 and
  +0.5. A value of 0 indicates negligible ageing (neither generally increasing
  nor generally decreasing reproduction with age); positive values indicate
  senescence (generally decreasing reproduction with age); negative values
  indicate negative senescence (generally increasing reproduction with age).
  A value of +0.5 indicates that (hypothetically) all individuals are born to
  individuals of age 0; a value of -0.5 indicates that all individuals are
  born at the age of maximum longevity.
}
\description{
Calculates a 'shape' value of distribution of reproduction over age by
comparing the area under a cumulative reproduction curve (over age) with the
area under a cumulative function describing constant reproduction.
}
\examples{
# increasing mx yields negative shape
mx <- c(0, 0, 0.3, 0.4, 0.5, 0.6)
shape_rep(mx)

# decreasing mx yields positive shape
mx <- c(1.1, 1.0, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4)
shape_rep(mx)

# constant mx yields shape = 0
mx <- c(0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)
shape_rep(mx)
}
\references{
Baudisch, A, Stott, I. 2019. A pace and shape perspective on fertility. Methods Ecol Evol. 10: 1941– 1951. <https://doi.org/10.1111/2041-210X.13289>
}
\seealso{
Other life history traits: 
\code{\link{entropy_d}()},
\code{\link{entropy_k}()},
\code{\link{gen_time}()},
\code{\link{life_expect_mean}()},
\code{\link{longevity}()},
\code{\link{net_repro_rate}()},
\code{\link{repro_maturity}},
\code{\link{shape_surv}()}
}
\author{
Iain Stott <iainmstott@gmail.com>
}
\concept{life history traits}
