% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zooroh_accessor.R
\name{zoodoris}
\alias{zoodoris}
\title{Returns number of HBD segments (or genome proportion) per size bins for DoRIS.}
\usage{
zoodoris(zres, minv, maxv, glen, method = "counts")
}
\arguments{
\item{zres}{The name of the zres object created by the zoorun function.}

\item{minv}{The minimum length of HBD segments (in Mb) used for the DoRIS analysis.}

\item{maxv}{The maximum length of HBD segments (in Mb) used for the DoRIS analysis.}

\item{glen}{The length of the genome in Mb (including only the autosomes, the space where
HBD segments have been searched for).}

\item{method}{The argument is used to indicate that function will return counts of
HBD segments (method = "counts") or proportion of the genome (method ="sharing") per
1 Mb bins.}
}
\value{
A data frame with three columns and one row per 1Mb bins. The first column
indicates the the length of smallest HBD segments in the bin, the second column
indicates the length of the largest HBD segments in the bin and the third column
indicates the number of segments in the bin or the proportion of the genome
in the bin.
}
\description{
The number of HBD segments in 1Mb bins is computed and the function returns a
table that can be used with DoRIS to estimate paste effective population size.
Alternatively, the proportion of the genome in the different 1 Mb bins is
computed. The user must specify the range of the bins (the smallest and largest
HBD segments considered).
#'
}
