% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cutoff.R
\name{plot_cutoff}
\alias{plot_cutoff}
\title{Check number of DE genes at different cutoff combinations}
\usage{
plot_cutoff(
  data = data,
  comp.names = NULL,
  FCflag = "logFC",
  FDRflag = "adj.P.Val",
  FCmin = 1.2,
  FCmax = 2,
  FCstep = 0.1,
  p.min = 0,
  p.max = 0.2,
  p.step = 0.01,
  plot.save.to = NULL,
  gen.3d.plot = TRUE,
  gen.plot = TRUE
)
}
\arguments{
\item{data}{Summary statistics table or a list of summary statistics tables from limma or DEseq2, where each row is a gene.}

\item{comp.names}{A character vector that contains the comparison names which correspond to the same order as \code{data}.}

\item{FCflag}{The column name of the log2FC in the summary statistics table. Default = "logFC".}

\item{FDRflag}{The column name of the False Discovery Rate (FDR) in the summary statistics table. Default = "adj.P.Val".}

\item{FCmin}{The minimum starting fold change cutoff to be checked, so the minimum fold change cutoff to be evaluated
will be FCmin + FCstep, FCmin default = 1.}

\item{FCmax}{The maximum fold change cutoff to be checked, default = 2.}

\item{FCstep}{The step from the minimum to maximum fold change cutoff, one step increase at a time, default = 0.01.}

\item{p.min}{The minimum starting FDR cutoff to be checked, so the minimum fold change cutoff to be evaluated
will be p.min + p.step, p.min default = 0.}

\item{p.max}{The maximum FDR cutoff to be checked, default = 0.2.}

\item{p.step}{The step from the minimum to maximum fold change cutoff, one step increase at a time, default = 0.005.}

\item{plot.save.to}{The address where to save the plot from simplified cutoff combination with FDR of 0.01, 0.05, 0.1, and 0.2.}

\item{gen.3d.plot}{Whether generate a 3d plotly object to visualize the result, only applys to single dataframe input, default = F.}

\item{gen.plot}{Whether generate a plot to visualize the result, default = T.}
}
\value{
If the input \code{data} is a data list, then a multi-facet ggplot plot object which contains each
of the summary statistics table will be returned; otherwise, if the input \code{data} is a data frame, then the function will return a list which contains 3 elements:
\item{df.sub}{A dataframe, which contains the number of genes(3rd column) with FDR (1st column), Fold Change (2nd column)}
\item{plot3d}{A plotly object to show the 3d illustration of all possible cutoff selectiosn and
the number of DE genes in the 3d surface}
\item{gp}{A ggplot object to show the simplified cutoff combination result}
}
\description{
This function processes summary statistics table generated by differential expression analysis
like \code{limma} or \code{DESeq2} to evaluate the number of differntially expressed genes with different FDR and
fold change cutoff.
}
\details{
The function takes the summary statistics and returns a list which contains 3 objects: a table which describes the number
of DE genes with different cutoff combinations of FDR and fold change, a ggplot object which depicts a simplified version of
cutoff selection combination, and a plotly 3d visulization object which depicts a high resolution of cutoff combinations.
The default range of the fold change is from 1 to 2, and p value is from 0 to 0.2, with the step of 0.01
for FC and 0.005 for FDR.
}
\examples{
plot_cutoff(Sample_summary_statistics_table)

plot_cutoff(data = list(Sample_summary_statistics_table, Sample_summary_statistics_table1),
           comp.names = c("A", "B"))



}
\references{
Xingpeng Li & Olya Besedina, RVA - RNAseq Visualization Automation tool.
}
