% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearningCurve.R
\name{LearningCurveSSL}
\alias{LearningCurveSSL}
\alias{LearningCurveSSL.matrix}
\title{Compute Semi-Supervised Learning Curve}
\usage{
LearningCurveSSL(X, y, ...)

\method{LearningCurveSSL}{matrix}(X, y, classifiers, measures = list(Accuracy
  = measure_accuracy), type = "unlabeled", n_l = NULL,
  with_replacement = FALSE, sizes = 2^(1:8), n_test = 1000,
  repeats = 100, verbose = FALSE, n_min = 1, dataset_name = NULL,
  test_fraction = NULL, fracs = seq(0.1, 0.9, 0.1), time = TRUE,
  pre_scale = FALSE, pre_pca = FALSE, low_level_cores = 1, ...)
}
\arguments{
\item{X}{design matrix}

\item{y}{vector of labels}

\item{...}{arguments passed to underlying function}

\item{classifiers}{list; Classifiers to crossvalidate}

\item{measures}{named list of functions giving the measures to be used}

\item{type}{Type of learning curve, either "unlabeled" or "fraction"}

\item{n_l}{Number of labeled objects to be used in the experiments (see details)}

\item{with_replacement}{Indicated whether the subsampling is done with replacement or not (default: FALSE)}

\item{sizes}{vector with number of unlabeled objects for which to evaluate performance}

\item{n_test}{Number of test points if with_replacement is TRUE}

\item{repeats}{Number of learning curves to draw}

\item{verbose}{Print progressbar during execution (default: FALSE)}

\item{n_min}{Minimum number of labeled objects per class in}

\item{dataset_name}{character; Name of the dataset}

\item{test_fraction}{numeric; If not NULL a fraction of the object will be left out to serve as the test set}

\item{fracs}{list; fractions of labeled data to use}

\item{time}{logical; Whether execution time should be saved.}

\item{pre_scale}{logical; Whether the features should be scaled before the dataset is used}

\item{pre_pca}{logical; Whether the features should be preprocessed using a PCA step}

\item{low_level_cores}{integer; Number of cores to use compute repeats of the learning curve}
}
\value{
LearningCurve object
}
\description{
Evaluate semi-supervised classifiers for different amounts of unlabeled training examples or different fractions of unlabeled vs. labeled examples.
}
\details{
\code{classifiers} is a named list of classifiers, where each classifier should be a function that accepts 4 arguments: a numeric design matrix of the labeled objects, a factor of labels, a numeric design  matrix of unlabeled objects and a factor of labels for the unlabeled objects.

\code{measures} is a named list of performance measures. These are functions that accept seven arguments: a trained classifier, a numeric design matrix of the labeled objects, a factor of labels, a numeric design  matrix of unlabeled objects and a factor of labels for the unlabeled objects, a numeric design matrix of the test objects and a factor of labels of the test objects. See \code{\link{measure_accuracy}} for an example.

This function allows for two different types of learning curves to be generated. If \code{type="unlabeled"}, the number of labeled objects remains fixed at the value of \code{n_l}, where \code{sizes} controls the number of unlabeled objects. \code{n_test} controls the number of objects used for the test set, while all remaining objects are used if \code{with_replacement=FALSE} in which case objects are drawn without replacement from the input dataset. We make sure each class is represented by at least \code{n_min} labeled objects of each class. For \code{n_l}, additional options include: "enough" which takes the max of the number of features and 20, max(ncol(X)+5,20), "d" which takes the number of features or "2d" which takes 2 times the number of features.

 If \code{type="fraction"} the total number of objects remains fixed, while the fraction of labeled objects is changed. \code{frac} sets the fractions of labeled objects that should be considered, while \code{test_fraction} determines the fraction of the total number of objects left out to serve as the test set.
}
\examples{
set.seed(1)
df <- generate2ClassGaussian(2000,d=2,var=0.6)

classifiers <- list("LS"=function(X,y,X_u,y_u) {
 LeastSquaresClassifier(X,y,lambda=0)}, 
  "Self"=function(X,y,X_u,y_u) {
    SelfLearning(X,y,X_u,LeastSquaresClassifier)}
)

measures <- list("Accuracy" =  measure_accuracy,
                 "Loss Test" = measure_losstest,
                 "Loss labeled" = measure_losslab,
                 "Loss Lab+Unlab" = measure_losstrain
)

# These take a couple of seconds to run
\dontrun{
# Increase the number of unlabeled objects
lc1 <- LearningCurveSSL(as.matrix(df[,1:2]),df$Class,
                        classifiers=classifiers,
                        measures=measures, n_test=1800,
                        n_l=10,repeats=3)

plot(lc1)

# Increase the fraction of labeled objects, example with 2 datasets
lc2 <- LearningCurveSSL(X=list("Dataset 1"=as.matrix(df[,1:2]),
                               "Dataset 2"=as.matrix(df[,1:2])),
                        y=list("Dataset 1"=df$Class,
                               "Dataset 2"=df$Class),
                        classifiers=classifiers,
                        measures=measures,
                        type = "fraction",repeats=3,
                        test_fraction=0.9)

plot(lc2)
}
}
\seealso{
Other RSSL utilities: 
\code{\link{SSLDataFrameToMatrices}()},
\code{\link{add_missinglabels_mar}()},
\code{\link{df_to_matrices}()},
\code{\link{measure_accuracy}()},
\code{\link{missing_labels}()},
\code{\link{split_dataset_ssl}()},
\code{\link{split_random}()},
\code{\link{true_labels}()}
}
\concept{RSSL utilities}
