% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym_interval_tsne.R
\name{sym.tsne.symbolic_tbl}
\alias{sym.tsne.symbolic_tbl}
\alias{sym.tsne}
\title{TSNE for symbolic data tables}
\usage{
sym.tsne(sym.data, initial_config = NULL, k = 2, initial_dims = 30,
 perplexity = 30,max_iter = 1000, min_cost = 0, epoch_callback = NULL,
 whiten = TRUE,epoch=100)
}
\arguments{
\item{sym.data}{symbolic data table}

\item{initial_config}{an argument providing a matrix specifying the initial embedding for X.}

\item{k}{the dimension of the resulting embedding.}

\item{initial_dims}{The number of dimensions to use in reduction method.}

\item{perplexity}{Perplexity parameter. (optimal number of neighbors)}

\item{max_iter}{Maximum number of iterations to perform.}

\item{min_cost}{The minimum cost value (error) to halt iteration.}

\item{epoch_callback}{A callback function used after each epoch (an epoch here means a set number of iterations)}

\item{whiten}{A boolean value indicating whether the matrix data should be whitened.}

\item{epoch}{The number of iterations in between update messages.}
}
\description{
TSNE for symbolic data tables
}
\examples{
\dontrun{
res <- sym.tsne(oils)
res
plot(res)
}

}
