% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.sd.R
\name{sym.sd}
\alias{sym.sd}
\title{Symbolic Standard Desviation}
\usage{
sym.sd(sym.var, method =
c('centers', 'interval', 'billard', 'modal'), na.rm = FALSE, ...)
}
\arguments{
\item{sym.var}{The symbolic variable.}

\item{method}{The method to be use.}

\item{na.rm}{As in R sd function.}

\item{...}{As in R sd function.}
}
\value{
return a real number.
}
\description{
Compute the symbolic standard desviation.
}
\examples{
data(example3)
sym.data<-example3
sym.sd(sym.var(sym.data,1))
sym.sd(sym.var(sym.data,2))
sym.sd(sym.var(sym.data,6))
sym.sd(sym.var(sym.data,6),method='interval')
sym.sd(sym.var(sym.data,6),method='billard')
sym.sd(sym.var(sym.data,3),method='modal')
}
\references{
Billard L. and  Diday E. (2006).
Symbolic data analysis: Conceptual statistics and data mining. Wiley, Chichester.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Symbolic}
\keyword{sd}
