% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.hclust.R
\name{sym.hclust}
\alias{sym.hclust}
\title{Symbolic Hierarchical Clustering}
\usage{
sym.hclust(sym.data, distance = c('hausdorff', 'centers'), p = 2,
method = c('ward', 'single', 'complete', 'average', 'mcquitty',
           'median', 'centroid'), members = NULL)
}
\arguments{
\item{sym.data}{The symbolic data table.}

\item{distance}{The distance to be use.}

\item{p}{The p in the Hausdorff distance :
\deqn{d(w_{u_1},w_{u_2}) = \left( \sum_{j=1}^m \Phi_j(w_{u_1},w_{u_2})^p  \right)^{1/p}}}

\item{method}{The method to be use, like in hclust R function.}

\item{members}{Like in hclust R function.}
}
\value{
Return a dendogram plot structure.
}
\description{
This function allows us to execute a symbolic
hierarchical clustering to interval variables.
}
\examples{
data(oils)
sh<-sym.hclust(oils)
plot(sh)
sh<-sym.hclust(oils,'centers')
plot(sh)
}
\references{
Carvalho F., Souza R.,Chavent M., and Lechevallier Y. (2006)
Adaptive Hausdorff distances and dynamic clustering of symbolic interval data. Pattern
Recognition Letters Volume 27, Issue 3, February 2006, Pages 167-179

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Clustering}
\keyword{Symbolic}
