% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TheilSenTrendFunctions.R
\name{annualtrend.ts}
\alias{annualtrend.ts}
\title{Explore long term annual trends with Theil-Sen Estimator}
\usage{
annualtrend.ts(record, valuecol, datecol, var, monthlybias = FALSE)
}
\arguments{
\item{record}{dataframe with record of estimated water quality}

\item{valuecol}{string, name of column with water quality values}

\item{datecol}{string, name of column with dates}

\item{var}{string, aggregator (e.g. mean, max)}

\item{monthlybias, }{calculates annual average using monthly averages (in case of differing numbers of samples for each month)}
}
\value{
summary of the Theil-Sen estimator
}
\description{
Calculates annual linear trend of average values and significance of  with Theil-Sen Estimator (used for robust to non-normal data)
}
\examples{
data(estimatedrecord)
annualtrend.ts(record=estimatedrecord,valuecol="EstChlValue",
datecol="ImageDate",var="mean",monthlybias="TRUE")
}
