% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OP.R
\name{OP}
\alias{OP}
\alias{as.OP}
\title{Optimization Problem Constructor}
\usage{
OP(objective, constraints, types, bounds, maximum = FALSE)

as.OP(x)
}
\arguments{
\item{objective}{an object inheriting from class \code{"objective"}.}

\item{constraints}{an object inheriting from class \code{"constraints"}.}

\item{types}{a character vector giving the types of the objective
variables, with \code{"C"}, \code{"I"}, and \code{"B"}
corresponding to continuous, integer, and binary, respectively, or
\code{NULL} (default), taken as all-continuous.  Recycled as
needed.}

\item{bounds}{\code{NULL} (default) or a list with elements
\code{upper} and \code{lower} containing the indices and
corresponding bounds of the objective variables.  The default for
each variable is a bound between 0 and \code{Inf}.}

\item{maximum}{a logical giving the direction of the
optimization. \code{TRUE} means that the objective is to maximize
the objective function, \code{FALSE} (default) means to minimize
it.}

\item{x}{an R object.}
}
\value{
an object of class \code{"OP"}.
}
\description{
Optimization problem constructor
}
\examples{
## Simple linear program.
## maximize:   2 x_1 + 4 x_2 + 3 x_3
## subject to: 3 x_1 + 4 x_2 + 2 x_3 <= 60
##             2 x_1 +   x_2 +   x_3 <= 40
##               x_1 + 3 x_2 + 2 x_3 <= 80
##               x_1, x_2, x_3 are non-negative real numbers

LP <- OP( c(2, 4, 3),
          L_constraint(L = matrix(c(3, 2, 1, 4, 1, 3, 2, 2, 2), nrow = 3),
                       dir = c("<=", "<=", "<="),
                       rhs = c(60, 40, 80)),
          max = TRUE )
LP

## Simple quadratic program.
## minimize: - 5 x_2 + 1/2 (x_1^2 + x_2^2 + x_3^2)
## subject to: -4 x_1 - 3 x_2       >= -8
##              2 x_1 +   x_2       >=  2
##                    - 2 x_2 + x_3 >=  0

QP <- OP( Q_objective (Q = diag(1, 3), L = c(0, -5, 0)),
          L_constraint(L = matrix(c(-4,-3,0,2,1,0,0,-2,1),
                                  ncol = 3, byrow = TRUE),
                       dir = rep(">=", 3),
                       rhs = c(-8,2,0)) )
QP
}
\author{
Stefan Theussl
}
