% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ValidCorrGpois.R
\name{ValidCorrGpois}
\alias{ValidCorrGpois}
\title{Validates Pairwise Correlations}
\usage{
ValidCorrGpois(corMat, theta.vec, lambda.vec, verbose = TRUE)
}
\arguments{
\item{corMat}{a positive definite target correlation matrix whose entries are within the valid correlation bounds.}

\item{theta.vec}{rate parameters in the generalized Poisson distribution. It is assumed that the
length of the vector is at least two, and each value has to be a positive number.}

\item{lambda.vec}{dispersion parameters in the generalized Poisson distribution. It is assumed that the length
of the vector is at least two. All lambda values have to be less than 1. For lambda < 0, lambda must be greater than or equal to -theta/4.}

\item{verbose}{logical variable that determines whether to display the traces. Default is set to TRUE.}
}
\value{
TRUE or FALSE.
}
\description{
\code{ValidCorrGpois} checks the validity of the values of pairwise correlations including
positive definiteness, symmetry, and correctness of the dimensions.
}
\examples{
\donttest{
 ValidCorrGpois(matrix(c(1, 0.9, 0.9, 1), byrow = TRUE, nrow = 2), 
                c(0.5, 0.5), c(0.1, 0.105), verbose = TRUE)
 ValidCorrGpois(matrix(c(1, 0.9, 0.9, 1), byrow = TRUE, nrow = 2), 
                c(3, 2), c(-0.3, -0.2), verbose = TRUE)}
}
\references{
Amatya, A. and Demirtas, H. (2017). PoisNor: An R package for generation of multivariate data with
 Poisson and normal marginals. \emph{Communications in Statistics - Simulation and Computation},
 \bold{46(3)}, 2241-2253.
 
 Demirtas, H. and Hedeker, D. (2011). A practical way for computing approximate lower and upper correlation bounds.
 \emph{The American Statistician}, \bold{65(2)}, 104-109.
}
