% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLOT_heatmap.R
\name{heatmapClass}
\alias{heatmapClass}
\title{Heatmap of the similarities between classes about clustering}
\usage{
heatmapClass(output, pkg = c("ggplot2", "plotly"), ...)
}
\arguments{
\item{output}{object returned by \emph{mixtCompLearn} function from \emph{RMixtComp} or \emph{rmcMultiRun} function from \emph{RMixtCompIO}}

\item{pkg}{"ggplot2" or "plotly". Package used to plot}

\item{...}{arguments to be passed to plot_ly. For pkg = "ggplot2", addValues = TRUE prints similarity values on the heatmap}
}
\description{
Heatmap of the similarities between classes about clustering
}
\details{
The similarities between classes k and g is defined by 1 - Sigma(k,g)
\deqn{Sigma(k,g)^2 = (1/n) * \sum_{i=1}^n (P(Z_i=k|x_i) - P(Z_i=g|x_i))^2}
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
                  var2 = as.character(c(rnorm(50, 2), rpois(50, 8))))
                  
model <- list(var1 = list(type = "Gaussian", paramStr = ""),
              var2 = list(type = "Poisson", paramStr = ""))

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

# plot
heatmapClass(resLearn)

}
\seealso{
\code{\link{computeSimilarityClass}}

Other plot: \code{\link{heatmapTikSorted}},
  \code{\link{heatmapVar}}, \code{\link{histMisclassif}},
  \code{\link{plot.MixtComp}},
  \code{\link{plotConvergence}},
  \code{\link{plotDataBoxplot}}, \code{\link{plotDataCI}},
  \code{\link{plotDiscrimClass}},
  \code{\link{plotDiscrimVar}},
  \code{\link{plotParamConvergence}},
  \code{\link{plotProportion}}
}
\author{
Matthieu MARBAC
}
\concept{plot}
