% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/senFolderToVar.R
\name{senFolderToVar}
\alias{senFolderToVar}
\title{Compute a remote sensing index from a time series of Sentinel-2 images}
\usage{
senFolderToVar(src, AppRoot, fun, getStack = FALSE, overwrite = FALSE,
  verbose = FALSE, resbands = c("10m", "20m", "60m"), ...)
}
\arguments{
\item{src}{the path to the folder with the Sentinel-2 multispectral images.}

\item{AppRoot}{directory where the outcoming time series is saved.}

\item{fun}{a \code{function} that computes the remote sensing index.}

\item{getStack}{logical argument. If \code{TRUE}, returns the time series of
images as a \code{RasterStack}, otherwise the images are saved in the Hard
Drive Device (HDD).}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}

\item{resbands}{the resolution of the image being used to compute index,
when the imagery comes from the Senintel-2 "\code{S2MSI2A}" product. By 
default, all resolutions (10m, 20m, and 60m) are used.}

\item{...}{arguments for nested functions.
 \itemize{
  \item \code{dates} a vector with the capturing dates being considered
  for mosaicking. If not supplied, all dates are mosaicked.
}}
}
\value{
this function does not return anything, unless \code{getStack = TRUE}
which then returns a \code{RasterStack} with the time series of with the
index.
}
\description{
\code{senFolderToVar} computes a remote sensing index from the spectral bands
of a time series of Sentinel-2 images. The images are specified by the path to
the folder that stores the imagery (resulting from the \code{\link{senMosaic}} 
function). The function returns a \code{RasterStack}  with a time series of 
images of the remote sensing index.
}
\details{
The function requires the definition of the \code{src} and \code{fun} 
arguments. The \code{src} is usually the path resulting from 
\code{\link{senMosaic}}. The \code{fun} argument can be any function from
this package beginning with “var” (\code{\link{varNDVI}}, 
\code{\link{varEVI}}, etc.). Custom functions can also be implemented.
If \code{fun = varRGB}, then the argument \code{getStack} must be equal to
\code{FALSE} and the red-green-blue (RGB) images must be imported afterwards.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# main output directory
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
print(wdir)
# download Sentinel-2 images
senDownSearch(startDate = as.Date("2018210","\%Y\%j"),
              endDate = as.Date("2018218","\%Y\%j"),
              platform = "Sentinel-2",
              extent = ex.navarre,
              product = "S2MSI1C",
              pathrow = c("R094"),
              username = "username",
              password = "password",
              AppRoot = wdir)
# folder with the unzipped images from Sentinel-2
wdir.sen <- file.path(wdir,"Sentinel-2")
wdir.sen.unzip <- file.path(wdir.sen, "unzip")
# mosaic the Sentinel-2 images
senMosaic(wdir.sen.unzip,
          AppRoot = wdir.sen,
          gutils = TRUE,
          out.name = "Navarre")
# path to the folder with the mosaicked images
wdir.sen.navarre <- file.path(wdir.sen, "Navarre")
wdir.sen.var <- file.path(wdir.sen.navarre, "Navarre_Variables")
dir.create(wdir.sen.var)
# generate EVI images of Navarre
senFolderToVar(wdir.sen.navarre,
               fun = varEVI,
               resbands = c("60m"),
               AppRoot = wdir.sen.var)
               
files.sen.evi <- list.files(file.path(wdir.sen.var,"EVI"),
                            pattern = "\\\\.tif$",
                            full.names = TRUE,
                            recursive = TRUE)

img.sen.evi <- lapply(files.sen.evi, raster)
spplot(img.sen.evi[[1]])
}
}
