% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsEspaGetOrderImages.R
\name{lsEspaGetOrderImages}
\alias{lsEspaGetOrderImages}
\title{Gets a first response from ESPA regarding a recent request}
\usage{
lsEspaGetOrderImages(username = NULL, password = NULL,
  c.handle = NULL, order.list = NULL, verbose = TRUE)
}
\arguments{
\item{username}{USGS's `EarthExplorer' username.}

\item{password}{USGS's `EarthExplorer' password.}

\item{c.handle}{a curl handler created with the package `\code{curl}' to
stablish a connection with a preset password and username. This argument
is mandatory if \code{username} and \code{password} are not defined.}

\item{order.list}{a list of orders from \code{\link{lsEspaOrderImages}}}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the 
running steps and warnings.}
}
\description{
\code{lsEspaGetOrderImages} obtains the identification number and the status
of the request from the EROS Centre Science Processing Architecture (ESPA).
}
\details{
This function is part of a group of functions used to pre-process Landsat
level-1 images. The pre-processing is carried out by ESPA on demand. 
\code{lsEspaGetOrderImages} takes the identification (ID) number of a
request carried out by \code{\link{lsEspaOrderImages}}. This ID is used to
follow up the processing status with \code{\link{lsEspaUpdateOrders}}. All the 
status messages and their interpretation can be found in the ESPA's API 
\href{https://www.usgs.gov/media/files/eros-science-processing-architecture-demand-interface-user-guide}{User Guide}.
}
\examples{
\dontrun{
wdir <- file.path(tempdir(),"Path_for_downloading_folder")
# search Landsat 7 level-2
sres <- ls7Search(startDate = as.Date("01-01-2017", "\%d-\%m-\%Y"),
                  endDate = as.Date("07-01-2017", "\%d-\%m-\%Y"),
                  lonlat = c(-1.64323, 42.81687),
                  AppRoot = wdir)
# request to ESPA the pre-pocessing of level-2 images to
# get the surface reflectance
order <- lsEspaOrderImages(search.res = sres,
                           username = "username", 
                           password = "password", 
                           product = 'sr',
                           verbose = FALSE)
# get an ID for our request
lsEspaGetOrderImages(username = "username", 
                     password = "password")
}
}
