\name{usEstUstarThreshold}
\alias{usEstUstarThreshold}
\title{usEstUstarThreshold - Estimating ustar threshold}
\description{Estimate the Ustar threshold by aggregating the estimates for
seasonal and temperature subsets.}
\usage{usEstUstarThreshold(ds, seasonFactor.v = usCreateSeasonFactorMonth(ds$sDateTime), 
    seasonFactorsYear = usGetYearOfSeason(seasonFactor.v, 
        ds$sDateTime), ctrlUstarEst.l = usControlUstarEst(), 
    ctrlUstarSub.l = usControlUstarSubsetting(), 
    fEstimateUStarBinned = usEstUstarThresholdSingleFw2Binned, 
    isCleaned = FALSE)}
\arguments{
  \item{ds}{data.frame with columns "sDateTime", "Ustar", "NEE", "Tair", and "Rg"}
  \item{seasonFactor.v}{factor for subsetting times (see details)}
  \item{seasonFactorsYear}{named integer vector: for each seasonFactor level, get the year
(aggregation period) that this season belongs to}
  \item{ctrlUstarEst.l}{control parameters for estimating uStar on a single binned series,
see \code{\link{usControlUstarEst}}}
  \item{ctrlUstarSub.l}{control parameters for
subsetting time series (number of temperature and Ustar classes \ldots),
see \code{\link{usControlUstarSubsetting}}}
  \item{fEstimateUStarBinned}{function to
estimate UStar on a single binned series,
see \code{\link{usEstUstarThresholdSingleFw2Binned}}}
  \item{isCleaned}{set to TRUE, if the data was cleaned already,
to avoid expensive call to \code{usGetValidUstarIndices}.}
}
\details{The threshold for sufficiently turbulent conditions u * (Ustar)
is estimated for different subsets of the time series.
From the estimates for each season (each value in \code{seasonFactor.v})
the maximum of all seasons of one year is reported as estimate for this year.
Within each season the time series is split by temperature classes.
Among these Ustar estimates, the median is reported as season value.

In order to split the seasons, the uses must provide a vector with argument
\code{seasonFactor.v}.
All positions with the same factor, belong to
the same season. It is conveniently generated by one of the following functions:
\itemize{
\item{ \code{\link{usCreateSeasonFactorMonth}}
(default DJF-MAM-JJA-SON with December from previous to January of the year) }
\item{ \code{\link{usCreateSeasonFactorMonthWithinYear}}
(default DJF-MAM-JJA-SON with December from the same year) }
\item{ \code{\link{usCreateSeasonFactorYday}}
for a refined specification of season starts. }
\item{ \code{\link{usCreateSeasonFactorYdayYear}}
for specifying different seasons season between years. }
}

The estimation of Ustar on a single binned series can be selected argument
\code{fEstimateUStarBinned}.
\itemize{
\item{ \code{\link{usEstUstarThresholdSingleFw1Binned}} }
\item{ \code{\link{usEstUstarThresholdSingleFw2Binned}} (default) }
}

This function is called by
\itemize{
\item{ \code{\link{sEddyProc_sEstUstarThreshold}} which stores the result
in the class variables (sUSTAR and sDATA).}
\item{ \code{\link{sEddyProc_sEstUstarThresholdDistribution}} which
additionally estimates median and confidence intervals for each year
by bootstrapping the original data within seasons.}
}

For inspecting the NEE~uStar relationship plotting is provided by
\code{\link{sEddyProc_sPlotNEEVersusUStarForSeason}}

\describe{\item{change point detection (CPT) method}{
With specifying
\code{ctrlUstarEst.l = usControlUstarEst(isUsingCPTSeveralT = TRUE)}
change point detection is applied instead of the moving point test
(e.g. with Fw2Binned).

The sometimes sensitive binning of uStar values within a temperature
class is avoided.
Further, possible spurious thresholds are avoid by testing that the
model with a threshold
fits the data better than a model without a threshold using a
likelihood ratio test.
In addition, with CPT seasons are excluded where a threshold
was detected in only less
than ctrlUstarEst.l$minValidUStarTempClassesProp (default 20\%) of the
temperature classes.

Note, that this method often gives higher estimates of the u * threshold.
}}

\describe{\item{One-big-season fallback}{
If there are too few records within one year, of when no season yielded a
finite u * Threshold estimate, then
the yearly u * Th is estimated by pooling the data from seasons within one
seasonYear.
The user can suppress using pooled data on few records by providing option
\code{ctrlUstarSub.l$isUsingOneBigSeasonOnFewRecords = FALSE}
(see \code{\link{usControlUstarSubsetting}})
}}}
\value{A list with entries
data.frame with columns "aggregationMode", "seasonYear", "season", "uStar"
with rows for "single": the entire aggregate (median across years)
, "seasonYear": each year (maximum across seasons or estimate on pooled data)
, "season": each season (median across temperature classes)
\item{seasonYear}{data.frame
listing results for year with columns "seasonYear"
, "uStarMaxSeason" the maximum across seasonal estimates within the year
, "uStarPooled" the estimate based on data pooled across the year
(only calculated on few valid records or on uStarMaxSeason was nonfinite)
, "nRec" number of valid records  (only if the pooled estimate was calculated)
, "uStarAggr" chosen estimate, corresponding to uStarPooled
if this was calculated,
or uStarMaxSeason or uStarTh across years if the former was non-finite}
\item{season}{data.frame listing results for each season
, "nRec" the number of valid records
, "uStarSeasonEst" the estimate for based on data within the season
(median across temperature classes)
, "uStarAggr" chose estimate, corresponding to uStarSeasonEst,
or the yearly seasonYear$uStarAggr, if the former was non-finite}
\item{tempInSeason}{numeric matrix
(nTemp x nAggSeason):
estimates for each temperature subset for each season}
\item{bins}{columns
\code{season}, \code{tempBin} and \code{uStarBin}
for each record of input \code{ds}
reporting classes of similar environmental conditions
that the record belongs to.
}}
\references{Ustar filtering following the idea in Papale, D. et al. (2006)
Towards a standardized processing of net ecosystem exchange measured with
eddy covariance technique: algorithms and uncertainty estimation.
Biogeosciences 3(4): 571-583.}
\author{TW, OM
Department for Biogeochemical Integration at MPI-BGC, Jena, Germany <REddyProc-help@bgc-jena.mpg.de> [cph], Thomas Wutzler <twutz@bgc-jena.mpg.de> [aut, cre], Markus Reichstein <mreichstein@bgc-jena.mpg.de> [aut], Antje Maria Moffat <antje.moffat@bgc.mpg.de> [aut, trl], Olaf Menzer <omenzer@bgc-jena.mpg.de> [ctb], Mirco Migliavacca <mmiglia@bgc-jena.mpg.de> [aut], Kerstin Sickel <ksickel@bgc-jena.mpg.de> [ctb, trl], Ladislav Šigut <sigut.l@czechglobe.cz> [ctb]}





