% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S2fsq.R
\name{S2fsq}
\alias{S2fsq}
\title{Covert S to Cohen's \emph{f}^2}
\usage{
S2fsq(S)
}
\arguments{
\item{S}{Numeric,the robust effect size index.}
}
\value{
Returns an estimate of Cohen's \emph{f}^2 based on the RESI
}
\description{
Converts robust effect size index (S) to Cohen's \emph{f}^2
(effect size for multiple regression) using the formula from Vandekar, Tao, & Blume (2020).
}
\details{
The formula for the conversion is:

\eqn{ f^2 = S^2}
}
\examples{
# fit a linear regression model with continuous outcome and predictor
mod = lm(charges ~ age, data = RESI::insurance)

# obtain t value for calculating RESI
t = summary(mod)$coefficients[2, "t value"]

# calculate RESI
S = t2S(t, n = 1338, rdf = 1336)

# convert to f^2
S2fsq(S)

}
