% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiCredibleInterval}
\alias{MultiCredibleInterval}
\title{Bayesian credible intervals for a series of MCMC chains}
\usage{
MultiCredibleInterval(data, position, level = 0.95)
}
\arguments{
  \item{data}{dataframe containing the output of the MCMC algorithm }
  \item{position}{numeric vector containing the position of the column corresponding to the MCMC chains of interest}
  \item{level}{probability corresponding to the level of confidence used to estimate the credible interval}
}
\value{
Returns a matrix of values containing the level of confidence and the endpoints of the shortest credible interval for each variable of the MCMC chain. The name of the resulting rows are the positions of the corresponding columns in the CSV file.
}
\description{
Estimation of the shorest credible interval for each variables of simulated  Markov chain. }
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Events)
  MultiCredibleInterval(Events, c(2,4,3), 0.95)
}
\keyword{ credible interval}
