% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{lambda}
\alias{lambda}
\title{Calculates Lambda, a measure of association for a cross-tabulation.}
\usage{
lambda(tab, digits = 3, detailed = FALSE)
}
\arguments{
\item{tab}{The conditional frequencies of a cross-tabulation. The dependent variable should correspond to rows and the independent variable, to columns.}

\item{digits}{Number of decimal places of Lambda reported (defaults to 3).}

\item{detailed}{Do you want detailed report on how lambda value calculated? (default is FALSE).}
}
\value{
Returns the value of Lambda.
}
\description{
Given a table of conditional frequencies, the lambda function calculates and returns Lambda, a measure of association between two categorical variables (factors). Lambda is equal to the proportion of errors reduced by knowledge of the independent variable.
}
\examples{
  library(RCPA3)
  
  conditional.frequencies <- table(dv=states$lgbtq.equality.3cat, iv=states$religiosity3)
  lambda(tab=conditional.frequencies, detailed=TRUE)
}
\keyword{internal}
