% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{IC_SP}
\alias{IC_SP}
\title{Confidence Interval for Seroprevalence}
\usage{
IC_SP(SP, n, conf.level = 0.95, method = "asymptotic")
}
\arguments{
\item{SP}{Seroprevalence estimate.}

\item{n}{Sample size.}

\item{conf.level}{Confidence level (default is 0.95).}

\item{method}{Method for calculating the confidence interval (default is "asymptotic"). Available methods: c("asymptotic","exact","ac","wilson","logit","cloglog")}
}
\value{
A vector with the lower and upper limits of the confidence interval.
}
\description{
Calculates the confidence interval for a seroprevalence estimate with a specified confidence level.
}
\examples{
IC_SP(0.25, 100, conf.level = 0.95, method = "asymptotic")
}
\references{
The methods available in this function are some of the available in the binom package. For more information, see \url{https://CRAN.R-project.org/package=binom }
}
