% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeAnnualStat.R
\name{makeAnnualStat}
\alias{makeAnnualStat}
\title{Compute annual statistic of a variable}
\usage{
makeAnnualStat(x, verbose = FALSE, sortData = FALSE, filterNum = TRUE,
  FUN = mean, ...)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{verbose}{logical. Print info as we go?}

\item{sortData}{logical. Sort \code{x} and \code{area} before computing?}

\item{filterNum}{logical. Only keep the years which share the most common count.
For example, only keep years with 12 months and discard those with 11 or fewer.}

\item{FUN}{function. Function to apply across months of year}

\item{...}{Other arguments passed on to \code{FUN}}
}
\value{
A \code{\link{cmip5data}} object, whose \code{val} field is the annual
mean of the variable. A \code{numMonths} field is also added
recording the number of months averaged for each year.
}
\description{
Most CMIP5 data are monthly, and we frequently want to summarize these to annual
numbers. This function does that (although annual files also occur, and will be
handled as well). The default statistic is \link{mean}, but any summary
function that returns a numeric result can be used.
}
\details{
The stat function is calculated for all combinations of lon,
lat, and Z (if present).
}
\note{
If \code{x} is not in a needed order (for example, \code{FUN} uses
weights in a different order), be sure to specify \code{sortData=TRUE}.
}
\examples{
d <- cmip5data(1970:1975)   # sample data
makeAnnualStat(d)
summary(makeAnnualStat(d))
summary(makeAnnualStat(d, FUN=sd))
}
\seealso{
\code{\link{makeZStat}} \code{\link{makeGlobalStat}} \code{\link{makeMonthlyStat}}
}

