% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QueryClass.R
\name{QueryClass}
\alias{QueryClass}
\title{QueryClass}
\description{
The client can be used in 'standard' mode and in 'query' mode.
    Query mode is used to define queries, binding variables and for iterative evaluation.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{QueryClass$new()}}
\item \href{#method-Bind}{\code{QueryClass$Bind()}}
\item \href{#method-Context}{\code{QueryClass$Context()}}
\item \href{#method-Close}{\code{QueryClass$Close()}}
\item \href{#method-ExecuteQuery}{\code{QueryClass$ExecuteQuery()}}
\item \href{#method-Info}{\code{QueryClass$Info()}}
\item \href{#method-Options}{\code{QueryClass$Options()}}
\item \href{#method-Updating}{\code{QueryClass$Updating()}}
\item \href{#method-More}{\code{QueryClass$More()}}
\item \href{#method-Next}{\code{QueryClass$Next()}}
\item \href{#method-Full}{\code{QueryClass$Full()}}
\item \href{#method-clone}{\code{QueryClass$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new instance from QueryClass
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$new(query, Parent)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query-string}

\item{\code{Parent}}{The 'Parent' for this QueryClass-instance}

\item{\code{sock}}{Session-socket}

\item{\code{Intercept}}{Pointer to the Intercept-method from the Session-object}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
QueryClass-instances can only be created by calling the 'Query'-method from
    the 'BasexClient'-class.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Bind"></a>}}
\if{latex}{\out{\hypertarget{method-Bind}{}}}
\subsection{Method \code{Bind()}}{
Binds a value to a variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$Bind(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Binding Information}

\item{\code{query_obj}}{QueryClass instance-ID}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
When using the primitive functions, this function can be chained.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Context"></a>}}
\if{latex}{\out{\hypertarget{method-Context}{}}}
\subsection{Method \code{Context()}}{
Binds a value to the context. The type will be ignored if the string is empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$Context(value, type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value that should be boud to the context}

\item{\code{type}}{The type will be ignored when the string is empty}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
When using the primitive functions, this function can be chained.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Close"></a>}}
\if{latex}{\out{\hypertarget{method-Close}{}}}
\subsection{Method \code{Close()}}{
Closes and unregisters the query with the specified ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$Close()}\if{html}{\out{</div>}}
}

\subsection{Details}{
When using the primitive functions, this function can be chained.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExecuteQuery"></a>}}
\if{latex}{\out{\hypertarget{method-ExecuteQuery}{}}}
\subsection{Method \code{ExecuteQuery()}}{
Executes a query.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$ExecuteQuery()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Info"></a>}}
\if{latex}{\out{\hypertarget{method-Info}{}}}
\subsection{Method \code{Info()}}{
Returns a string with query compilation and profiling info.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$Info()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Options"></a>}}
\if{latex}{\out{\hypertarget{method-Options}{}}}
\subsection{Method \code{Options()}}{
Returns a string with all query serialization parameters, which
    can e.g. be assigned to the serializer option.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$Options()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Updating"></a>}}
\if{latex}{\out{\hypertarget{method-Updating}{}}}
\subsection{Method \code{Updating()}}{
Check if the query contains updating expressions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$Updating()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-More"></a>}}
\if{latex}{\out{\hypertarget{method-More}{}}}
\subsection{Method \code{More()}}{
Indicates if there are any other results in the query-result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$More()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Next"></a>}}
\if{latex}{\out{\hypertarget{method-Next}{}}}
\subsection{Method \code{Next()}}{
Returns the next result when iterating over a query
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$Next()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Full"></a>}}
\if{latex}{\out{\hypertarget{method-Full}{}}}
\subsection{Method \code{Full()}}{
Executes a query and returns a vector with all resulting items as strings,
    prefixed by the 'XDM' (Xpath Data Model) Meta Data <https://www.xdm.org/>.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$Full()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{QueryClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
