% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RBF-fn.R
\name{backf.rob}
\alias{backf.rob}
\title{Robust Backfitting}
\usage{
backf.rob(Xp, yp, windows, point = NULL, epsilon = 1e-06, degree = 0,
  sigma.hat = NULL, prob = NULL, max.it = 50, k.h = 1.345,
  k.t = 4.685, type = "Huber")
}
\arguments{
\item{Xp}{a matrix (n x p) containing the explanatory variables}

\item{yp}{vector of responses (missing values are allowed)}

\item{windows}{vector of bandwidths for the local polynomial smoother,
one per explanatory variable.}

\item{point}{matrix of points where predictions will be computed and returned.}

\item{epsilon}{convergence criterion. Maximum allowed relative difference between
consecutive estimates}

\item{degree}{degree of the local polynomial smoother. Defaults to \code{0} (local constant).}

\item{sigma.hat}{estimate of the residual standard error. If \code{NULL} (default) we use the
\link{mad} of the residuals obtained with local medians.}

\item{prob}{vector of probabilities of observing each response (length n).
Defaults to \code{NULL} and in that case it is ignored.}

\item{max.it}{Maximum number of iterations for the algorithm.}

\item{k.h}{tuning constant for a Huber-type loss function.}

\item{k.t}{tuning constant for a Tukey-type loss function.}

\item{type}{one of either \code{'Tukey'} or \code{'Huber'}.}
}
\value{
A list with the following components:
\item{alpha}{Estimate for the intercept.}
\item{g.matrix }{Matrix of estimated additive components (n by p).}
\item{prediction }{Matrix of estimated additive components for the points listed in
the argument \code{point}.}
\item{sigma.hat }{Estimate of the residual standard error.}
}
\description{
This function computes a robust backfitting algorithm for additive models
}
\details{
This function computes a robust backfitting algorithm for additive models
using robust local polynomial smoothers.
}
\examples{
data(airquality)
x <- airquality
x <- x[complete.cases(x), c('Ozone', 'Solar.R', 'Wind', 'Temp')]
y <- as.vector(x$Ozone)
x <- as.matrix(x[, c('Solar.R', 'Wind', 'Temp')])
tmp <- backf.rob(Xp = x, yp=y, windows=c(136.7, 8.9, 4.8) , degree=1)

}
\references{
Boente G, Martinez A, Salibian-Barrera M. Robust estimators
for additive models using backfitting. Journal of Nonparametric Statistics,
2017; 29:744-767. https://doi.org/10.1080/10485252.2017.1369077
}
\author{
Matias Salibian-Barrera, \email{matias@stat.ubc.ca}, Alejandra Martinez
}
