% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test3sr.R
\name{test3sr}
\alias{test3sr}
\title{Test3.SR}
\usage{
test3sr(X, freq, verbose = TRUE, rounding = 3)
}
\arguments{
\item{X}{is a matrix of encounter histories with K occasions}

\item{freq}{is a vector of the number of individuals with the corresponding encounter history}

\item{verbose}{controls the level of the details in the outputs; default is TRUE for all details}

\item{rounding}{is the level of rounding for outputs; default is 3}
}
\value{
This function returns a list with first component the overall test and second component a data.frame with 4 columns for components i (2:K-1) (in rows) of test3.sri: component, statistic of the test, p-value, signed test, test performed.
}
\description{
This function performs Test3.SR
}
\examples{
# read in the classical dipper dataset
dipper = system.file("extdata", "ed.inp", package = "R2ucare")
dipper = read_inp(dipper,group.df=data.frame(sex=c('Male','Female')))

# Get encounter histories, counts and groups:
dip.hist = dipper$encounter_histories
dip.freq = dipper$sample_size
dip.group = dipper$groups

# split the dataset in males/females
mask = (dip.group == 'Female')
dip.fem.hist = dip.hist[mask,]
dip.fem.freq = dip.freq[mask]
mask = (dip.group == 'Male')
dip.mal.hist = dip.hist[mask,]
dip.mal.freq = dip.freq[mask]

# Test3SR for males
res.males = test3sr(dip.mal.hist, dip.mal.freq)
res.males
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>, Jean-Dominique Lebreton, Rémi Choquet, Roger Pradel
}
\keyword{package}

