% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overall_CJS.R
\name{overall_CJS}
\alias{overall_CJS}
\title{Overall goodness-of-fit test for the Cormack-Jolly-Seber model}
\usage{
overall_CJS(X, freq, rounding = 3)
}
\arguments{
\item{X}{is a matrix of encounter histories}

\item{freq}{is a vector of the number of individuals with the corresponding encounter history}

\item{rounding}{is the level of rounding for outputs; default is 3}
}
\value{
This function returns a data.frame with the value of the test statistic, the degrees of freedom and the p-value of the test.
}
\description{
This function performs the overall goodness-of-fit test for the Cormack-Jolly-Seber model.
It is obtained as the sum of the 4 components Test3.SR, Test3.SM, Test2.CT and Test2.CL.
}
\examples{
# read in the classical dipper dataset
dipper = system.file("extdata", "ed.inp", package = "R2ucare")
dipper = read_inp(dipper,group.df=data.frame(sex=c('Male','Female')))

# Get encounter histories, counts and groups:
dip.hist = dipper$encounter_histories
dip.freq = dipper$sample_size
dip.group = dipper$groups

# split the dataset in males/females
mask = (dip.group == 'Female')
dip.fem.hist = dip.hist[mask,]
dip.fem.freq = dip.freq[mask]
mask = (dip.group == 'Male')
dip.mal.hist = dip.hist[mask,]
dip.mal.freq = dip.freq[mask]

# for females
overall_CJS(dip.fem.hist, dip.fem.freq)
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>,Jean-Dominique Lebreton, Rémi Choquet, Roger Pradel
}
\keyword{package}

