% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QuantumClone_v3.R
\name{plot_with_margins_densities}
\alias{plot_with_margins_densities}
\title{Plot with margin densities}
\usage{
plot_with_margins_densities(QClone_Output)
}
\arguments{
\item{QClone_Output}{Output from QuantumClone algorithm}
}
\description{
Adapted from http://stackoverflow.com/questions/11883844/inserting-a-table-under-the-legend-in-a-ggplot2-histogram
Uses gridExtra package
}
\examples{
require(ggplot2)
require(gridExtra)
print("Creating data formated as QuantumClone analysis")
print("Cluster 1: coordinates (0.8,0.7)")
print("Cluster 2: coordinates (0.3,0.4)")
QC_out<-list(cluster=rep(c(1,2),each=50),
       filtered.data=list(data.frame(id=1:100,Cellularity=c(rnorm(n=50,mean=0.8,sd=0.1),
       rnorm(n=50,0.3,0.08))),
       data.frame(id=1:100,Cellularity=c(rnorm(n=50,mean=0.700,
       sd=0.095),rnorm(n=50,mean=0.400,sd=0.085)))))
plot_with_margins_densities(QC_out)
}
\keyword{Densities}
\keyword{Plot}

