% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantCI.R
\name{quantCI}
\alias{quantCI}
\title{quantCI}
\usage{
quantCI(x, q, alpha, method)
}
\arguments{
\item{x}{vector of data}

\item{q}{the quantile}

\item{alpha}{the significance level}

\item{method}{the method used for calculate the confidence interval. Options are "exact" or "approximate".}
}
\value{
returns a list of 5 values:
\item{u1}{the lower confidence limit of the quantile}
\item{u2}{the upper confidence limit of the quantile}
\item{lower.ci}{the estimated x value at u1}
\item{qx}{the estimate x value of at the quantile q}
\item{upper.ci}{the estimated x value at u2}
}
\description{
Calculate nonparametric confidence intervals for quantiles using fractional order statistics,
}
\examples{
x <- c(3.5,2.4,2.1,1.3,1.2,2.2,2.6,4.2)
quantCI(x, q=0.5, alpha=0.05, method = "exact")

}
\author{
Nicholas Hutson
}
