% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_theme_OC.R
\name{get_data_theme_OC}
\alias{get_data_theme_OC}
\title{Retrieve Data from OpenCoesione Database by Theme's Project}
\usage{
get_data_theme_OC(
  themes,
  cod_reg = NULL,
  cod_prov = NULL,
  cod_mun = NULL,
  start = NULL,
  end = NULL,
  geo_ref = NULL,
  soil_defense = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{themes}{character. Vector specifying one or more theme of interest. To get information about the codes associated to each theme use the function \code{\link{get_info_OC}.}}

\item{cod_reg}{character. The ISTAT regional code is used to filter data based on one or more specific regions of interest. (See \code{\link{get_codes}} function)}

\item{cod_prov}{character. The ISTAT province code is used to filter data based on one or more specific provinces of interest. (See \code{\link{get_codes}} function)}

\item{cod_mun}{character. The ISTAT municipality code is used to specify one or more municipalities of interest within the region(s) of interest. (See \code{\link{get_codes}} function)}

\item{start}{character (format YYYY-mm-dd). Effective starting date of the project. This date can be of interest for filtering and analyzing relevant data.}

\item{end}{character (format YYYY-mm-dd). Effective ending date of the project. This date can be of interest for filtering and analyzing relevant data.}

\item{geo_ref}{character. The georeference data can be specified using the \code{geo_ref} argument. If set to \code{A}, the function returns shape polygons of each municipality. If set to \code{C}, it retrieves the coordinates of the centroids of each municipality.}

\item{soil_defense}{Logical, default set to \code{FALSE}. If only soil defense data are of interest set the argument to \code{TRUE}.}

\item{verbose}{Logic value (TRUE or FALSE). Toggle warnings and messages. If 'verbose = TRUE' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose = FALSE' any message about
the progression is suppressed.}
}
\value{
Object of classe \code{data.frame} showing 42 variables:
Descriptive Variables:
\itemize{
\item{Local Project Code (\code{character})}
\item{CUP (\code{character})}
\item{Intervention (\code{character})}
}

Financial Variable:
\itemize{
\item{EU Funding (\code{numeric})}
\item{FESR EU Funding (\code{numeric})}
\item{FSE EU Funding (\code{numeric})}
\item{FEASR EU Funding (\code{numeric})}
\item{FEAMP EU Funding (\code{numeric})}
\item{IOG EU Funding (\code{numeric})}
\item{Fondo di Rotazione ITA (\code{numeric})}
\item{FSC ITA Funding (\code{numeric})}
\item{PAC ITA Funding (\code{numeric})}
\item{Completamenti ITA Funding (\code{numeric})}
\item{Other Measures ITA Funding (\code{numeric})}
\item{Region Funding (\code{numeric})}
\item{Province Funding (\code{numeric})}
\item{Municipality Funding (\code{numeric})}
\item{Released Resources (\code{logic})}
\item{Other Public Funding (\code{numeric})}
\item{Foreign State Funding (\code{numeric})}
\item{Private Funding (\code{numeric})}
\item{Total Public Funding (\code{numeric})}
\item{Total Funding (\code{numeric})}
}

Geographical References:
\itemize{
\item{DEN_MUNICIPALITY (\code{character})}
\item{DEN_REGION (\code{character})}
\item{DEN_PROVINCE (\code{character})}
\item{COD_REGION (\code{character})}
\item{COD_PROVINCE (\code{character})}
\item{COD_MUNICIPALITY (\code{character})}
\item{geom (\code{character})}
}

Legislative process main steps:
\itemize{
\item{Feasibility Study Starting Date (\code{integer})}
\item{Feasibility Study Ending Date (\code{integer})}
\item{Preliminary Design Starting Date (\code{integer})}
\item{Preliminary Design Ending Date (\code{integer})}
\item{Definitive Design Starting Date (\code{integer})}
\item{Definitive Design Ending Date (\code{integer})}
\item{Executive Design Starting Date (\code{integer})}
\item{Executive Design Ending Date (\code{integer})}
\item{Works Execution Starting Date (\code{integer})}
\item{Works Execution Ending Date (\code{integer})}
\item{Conclusion Starting Date (\code{character})}
\item{Conclusion Ending Date (\code{character})}
}
}
\description{
The \code{get_data_theme_OC} function allows users to fetch data from the OpenCoesione database based on specific themes related to projects.
}
\examples{
data <- get_data_theme_OC("AMBIENTE", start = "2022-01-01", end = "2022-12-31")

}
\references{
\href{https://opencoesione.gov.it/en/dati/}{Open Coesione}
}
\author{
Lorena Ricciotti
}
