% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_pert_estocastico.R
\name{stochastic.pert}
\alias{stochastic.pert}
\title{Stochastic projects}
\usage{
stochastic.pert(precedence, distribution, values, percentile = 0.95,
  compilations = 1000)
}
\arguments{
\item{precedence}{A matrix that indicates the order of precedence between activities. If the value \eqn{(i,j)} is equal to 1 then \eqn{i} precedes \eqn{j}.}

\item{distribution}{Type of distribution that each activities' duration has. It can be NORMAL, TRIANGLE, EXPONENTIAL, UNIFORM and EMPIRICAL.}

\item{values}{Matrix with the parameters corresponding to the distribution associated with the duration for each activity. Considering i as an activity we have the following cases. If the distribution is TRIANGLE, then (i, 1) it is the minimum value, (i, 2) the maximum value and (i, 3) the mode. If the distribution is NORMAL, (i, 1) is the mean and (i, 2) the variance. If the distribution is EXPONENTIAL, then (i, 1) is the \eqn{\lambda} parameter. If the distribution is UNIFORM, (i, 1) it is the minimum value and (i, 2) the maximum value. Finally, if the distribution is EMPIRICAL, then (i,j), for all \eqn{j\in \{1,...,M\}} such that \eqn{M>0}, is the sample.}

\item{percentile}{Percentile used to calculate the maximum time allowed for the duration of the project (Default=0.95).}

\item{compilations}{Number of compilations that the function will use for average calculations (Default=1000).}
}
\value{
Two values, average duration time and the maximum time allowed, a critically index vector and a durations histogram.
}
\description{
This function calculates the average duration time for a stochastic project and the activities criticality index. It also plots in a histogram the duration of the project, as well as the estimate density and the normal density.
}
\examples{
precedence<-matrix(c(0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0),nrow=5,ncol=5,byrow=TRUE)
distribution<-c("TRIANGLE","TRIANGLE","TRIANGLE","TRIANGLE","TRIANGLE")
values<-matrix(c(1,3,2,1/2,3/2,1,1/4,9/4,1/2,3,5,4,1,3.5,1.5),nrow=5,byrow=TRUE)
percentile<-0.95
stochastic.pert(precedence,distribution,values,percentile)

}
