% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_outs.R
\name{extr_outs}
\alias{extr_outs}
\title{Extracting outputs from \code{\link[=bayes_met]{bayes_met()}} objects}
\usage{
extr_outs(
  data,
  trait,
  gen,
  model,
  effects,
  nenv,
  probs = c(0.025, 0.975),
  check.stan.diag = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame containing the observations}

\item{trait}{A character representing the name of the column that
corresponds to the analysed trait}

\item{gen}{A character representing the name of the column that
corresponds to the evaluated genotypes}

\item{model}{An object containing the Bayesian model fitted using \code{rstan}}

\item{effects}{A string vector containing the codes of the effects included
in the model. The codes are:
\itemize{
\item \code{r} : replicate effect
\item \code{b} : block inside replicate effect (if the trials were laid out in
incomplete blocks design)
\item \code{l} : environment effect
\item \code{m} : region effect (if it is available)
\item \code{g} : genotypic effect
\item \code{gl} : genotype-by-environment effect
\item \code{gm} : genotype-by-region effect
}}

\item{nenv}{The number of environments in the analysis}

\item{probs}{A vector with two elements representing the probabilities
(in decimal scale) that will be considered for computing the quantiles.}

\item{check.stan.diag}{A logical value indicating whether the function should
extract some diagnostic using native \code{rstan} functions.}

\item{verbose}{A logical value. If \code{TRUE}, the function will indicate the
completed steps. Defaults to \code{FALSE}}

\item{...}{Passed to \code{\link[rstan:stan_plot_diagnostics]{rstan::stan_diag()}}}
}
\value{
The function returns a list with:
\itemize{
\item \code{post} : a list with the posterior of the effects, and the data
generated by the model
\item \code{variances} : a data frame with the variances of each effect
\item \code{map} : a list with the maximum posterior values of each effect
\item \code{ppcheck} : a matrix containing the p-values of maximum, minimum,
median, mean and standard deviation; effective number of parameters, WAIC2
value, Rhat and effective sample size.
\item \code{fun.plots} : a list with three types of ggplots: histograms, trace plots and density
plots. These will be available for all effects declared at the \code{effects} argument.
}
}
\description{
This function extracts outputs of the Bayesian model fitted
using \code{\link[=bayes_met]{bayes_met()}}, and provides some diagnostics about the model
}
\details{
More details about the usage of \code{extr_outs}, as well as the other function of
the \code{ProbBreed} package can be found at \url{https://saulo-chaves.github.io/ProbBreed_site/}.
}
\examples{
\donttest{
mod = bayes_met(data = soy,
                gen = "Gen",
                env = "Env",
                repl = NULL,
                reg = "Reg",
                res.het = FALSE,
                trait = "Y",
                iter = 2000, cores = 1, chain = 4)

outs = extr_outs(data = soy, trait = "Y", gen = "Gen", model = mod,
                 effects = c('l','g','gl','m','gm'),
                 nenv = length(unique(soy$Env)),
                 probs = c(0.05, 0.95),
                 check.stan.diag = TRUE,
                 verbose = FALSE)
                 }
}
\seealso{
\code{\link[rstan:stan_plot_diagnostics]{rstan::stan_diag()}}, \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
