% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recent_bills_by_member.R
\name{recent_bills_by_member}
\alias{recent_bills_by_member}
\title{Get Recent Bills by a Specific Member}
\usage{
recent_bills_by_member(member_id, type, page = 1, myAPI_Key)
}
\arguments{
\item{member_id}{member-id    The ID of the member to retrieve; it is assigned by the Biographical Directory of the United States Congress or can be retrieved from a member list request.}

\item{type}{introduced or updated}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
the 20 bills most recently introduced or updated by a particular member. Results can include more than one Congress.
}
\description{
Use this request type to get the 20 bills most recently introduced or updated by a particular member.
Results can include more than one Congress. HTTP Request: GET https://api.propublica.org/congress/v1/members/{member-id}/bills/{type}.json
}
\examples{
\dontrun{
recent_bills_by_member('L000287', 'introduced')
}
}
