% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoFAST.R
\name{NCFM}
\alias{NCFM}
\title{Cell-feature coembedding for scRNA-seq data}
\usage{
NCFM(
  object,
  assay = NULL,
  slot = "data",
  nfeatures = 2000,
  q = 10,
  reduction.name = "ncfm",
  weighted = FALSE,
  var.features = NULL
)
}
\arguments{
\item{object}{a Seurat object.}

\item{assay}{an optional string, specify the name of assay in the Seurat object to be used, `NULL` means default assay in seu.}

\item{slot}{an optional string, specify the name of slot.}

\item{nfeatures}{an optional integer, specify the number of features to select as top variable features. Default is 2000.}

\item{q}{an optional positive integer, specify the dimension of low dimensional embeddings to compute and store. Default is 10.}

\item{reduction.name}{an optional string, specify the dimensional reduction name, `ncfm` by default.}

\item{weighted}{an optional logical value, specify whether use weighted method.}

\item{var.features}{an optional string vector, specify the variable features used to calculate cell embedding.}
}
\description{
Cell-feature coembedding for scRNA-seq data based on FAST model.
}
\examples{
data(pbmc3k_subset)
pbmc3k_subset <- NCFM(pbmc3k_subset)
}
